@echo off

set JAVA=..\jdk\bin\java

if not exist "stare-javafx-client-2.0.0.jar" (
    echo Incorrect current working directory: %CD%
    goto end_error
)
echo Current working directory: %CD%

set properties=%SCICHAINS_IDE_PROPERTIES%
rem - You can specify additional properties in SCICHAINS_IDE_PROPERTIES environment variables

set properties=%properties% -Dnet.algart.executors.demo_chains=../demo/chains
rem - Path for "Open demo chains..." menu command

rem set properties=%properties% -Dcom.scichains.ide.connection.host=localhost
rem set properties=%properties% -Dcom.scichains.ide.connection.port=50051
rem - Allows to specify non-standard connection port/host
rem (must match the corresponding values in bin/config.json file)

set cp="stare-javafx-client-2.0.0.jar;lib/*;modules/*"

"%JAVA%" -version
rem cmd does not alloy to use '=' in command line argument (it is ignored by cmd interpreter)
"%JAVA%" --module-path modules --add-modules javafx.base,javafx.controls,javafx.fxml,javafx.graphics,javafx.media,javafx.swing,javafx.web %properties% -cp %cp% %1 %2 %3 %4 %5 %6 %7 %8

:end
timeout 5
exit

:end_error
echo Fix described issue and re-run application
timeout 10
exit