# Made by ChatGPT
from java.awt.image import BufferedImage
from java.awt import Color, GradientPaint, Font, RenderingHints, BasicStroke, Polygon
import math

def make_buffered_image(dimX, dimY, text):
    print(f"-- make_buffered_image: {dimX}x{dimY}")

    image = BufferedImage(dimX, dimY, BufferedImage.TYPE_INT_RGB)
    g2 = image.getGraphics()

    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON)

    gradient = GradientPaint(0, 0, Color.CYAN, dimX, dimY, Color.MAGENTA)
    g2.setPaint(gradient)
    g2.fillRect(0, 0, dimX, dimY)

    def draw_star_of_david(centerX, centerY, radius):
        def create_triangle(angle_offset):
            triangle = Polygon()
            for i in range(3):
                angle = angle_offset + i * 2 * math.pi / 3
                x = centerX + radius * math.cos(angle)
                y = centerY + radius * math.sin(angle)
                triangle.addPoint(int(round(x)), int(round(y)))
            return triangle

        up_triangle = create_triangle(-math.pi / 2)   # вверх
        down_triangle = create_triangle(math.pi / 2)  # вниз

        g2.setColor(Color(0, 200, 0, 128))
        g2.fillPolygon(up_triangle)
        g2.fillPolygon(down_triangle)

        g2.setStroke(BasicStroke(3.0))
        g2.setColor(Color.WHITE)
        g2.drawPolygon(up_triangle)
        g2.drawPolygon(down_triangle)

    radius = min(dimX, dimY) / 4
    draw_star_of_david(dimX / 2, dimY / 2, radius)

    font = Font("Serif", Font.BOLD, int(dimY / 10))
    g2.setFont(font)

    fm = g2.getFontMetrics()
    text_width = fm.stringWidth(text)
    text_height = fm.getAscent()

    x = (dimX - text_width) / 2
    y = (dimY + text_height) / 2

    g2.setColor(Color.DARK_GRAY)
    g2.drawString(text, int(round(x + 3)), int(round(y + 3)))

    g2.setColor(Color.WHITE)
    g2.drawString(text, int(round(x)), int(round(y)))

    g2.dispose()
    print("-- make_buffered_image done")
    return image

def build_image(dimX=1000, dimY=1000, text="Hello"):
    return make_buffered_image(int(dimX), int(dimY), text)

def execute(params, inputs, outputs):
    outputs.m1 = build_image(params.a, params.b, params.c)
    return "Hello! figure is in m1"

