// Made by ChatGPT
import {buildMat} from "./filling_bytes.mjs";

function drawOctahedron(image, dimX, dimY, angleX, angleY, angleZ) {
    console.log("-- drawOctahedron at Graphics2D: " + dimX + "x" + dimY + " at " + image)
    angleX = !angleX ? 0 : parseFloat(angleX)
    angleY = !angleY ? 0 : parseFloat(angleY)
    angleZ = !angleZ ? 0 : parseFloat(angleZ)
    let Color = Java.type("java.awt.Color");
    let BasicStroke = Java.type("java.awt.BasicStroke");
    let RenderingHints = Java.type("java.awt.RenderingHints");

    let g = image.getGraphics();
    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    let verts = [
        [ 1,  0,  0],
        [-1,  0,  0],
        [ 0,  1,  0],
        [ 0, -1,  0],
        [ 0,  0,  1],
        [ 0,  0, -1]
    ];

    function rotate(v) {
        let [x, y, z] = v;
        // X
        [y, z] = [y * Math.cos(angleX) - z * Math.sin(angleX),
            y * Math.sin(angleX) + z * Math.cos(angleX)];
        // Y
        [x, z] = [x * Math.cos(angleY) + z * Math.sin(angleY),
            -x * Math.sin(angleY) + z * Math.cos(angleY)];
        // Z
        [x, y] = [x * Math.cos(angleZ) - y * Math.sin(angleZ),
            x * Math.sin(angleZ) + y * Math.cos(angleZ)];
        return [x, y, z];
    }

    let rotated = verts.map(rotate);
    let projected = rotated.map(([x, y, z]) => [x, y]);
    let zs = rotated.map(([x, y, z]) => z);

    let xs = projected.map(p => p[0]);
    let ys = projected.map(p => p[1]);
    let minX = Math.min(...xs), maxX = Math.max(...xs);
    let minY = Math.min(...ys), maxY = Math.max(...ys);

    let margin = 40;
    let scale = Math.min(
        (dimX - 2 * margin) / (maxX - minX),
        (dimY - 2 * margin) / (maxY - minY)
    );

    let vertsImg = projected.map(([x, y]) => [
        Math.round((x - minX) * scale + margin),
        Math.round((y - minY) * scale + margin)
    ]);

    let faces = [
        [0, 2, 4],
        [2, 1, 4],
        [1, 3, 4],
        [3, 0, 4],
        [0, 5, 2],
        [2, 5, 1],
        [1, 5, 3],
        [3, 5, 0]
    ];

    let colors = [
        new Color(255, 128, 128),
        new Color(255, 200, 200),
        new Color(255, 100, 100),
        new Color(200,  50,  50),
        new Color(128, 128, 255),
        new Color(200, 200, 255),
        new Color(100, 100, 255),
        new Color( 50,  50, 200)
    ];

    let faceData = faces.map((face, i) => {
        let avgZ = (rotated[face[0]][2] + rotated[face[1]][2] + rotated[face[2]][2]) / 3.0;
        return { face, color: colors[i], avgZ };
    });

    faceData.sort((a, b) => a.avgZ - b.avgZ);

    for (let { face, color } of faceData) {
        let xPoints = Java.to(face.map(j => vertsImg[j][0]), "int[]");
        let yPoints = Java.to(face.map(j => vertsImg[j][1]), "int[]");

        g.setColor(color);
        g.fillPolygon(xPoints, yPoints, 3);

        g.setColor(Color.BLACK);
        g.drawPolygon(xPoints, yPoints, 3);
    }

    g.dispose();
    console.log("-- drawOctahedron done");
}

export function changeMat(mat, angleX, angleY, angleZ) {
    if (mat == null) return mat;
    let dimX = mat.getDimX()
    let dimY = mat.getDimY()
    let image = mat.toBufferedImage()
    drawOctahedron(image, dimX, dimY, angleX, angleY, angleZ)
    mat.setTo(image);
    console.log("-- Corrected SMat: " + mat)
    return mat;
}

export function execute(params, inputs, outputs) {
    outputs.m1 = changeMat(inputs.m1, params.a, params.b, params.c)
    return "Hello, see results in \"m1\" output"
}

