@echo off
set SERVICE_EXE_FILE=__algart-executor-service.exe
set SERVICE_NAME=SciChain

if not exist "%~dp0%SERVICE_EXE_FILE%" (
	echo Cannot found %SERVICE_EXE_FILE% [%~dp0%SERVICE_EXE_FILE%]
	goto end_error
)
if "%1" EQU "create" (
	goto service_create
)
if "%1" EQU "start" (
	goto service_start
)
if "%1" EQU "stop" (
	goto service_stop
)
if "%1" EQU "delete" (
	goto service_delete
)
if "%1" EQU "status" (
	goto service_status
)
echo Usage: 
echo     service.cmd action
echo Possible action: create, start, stop, delete, status
goto end

:service_create
call :check_privileges
sc queryex type= service state= all | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% EQU 0 (
	echo Service "%SERVICE_NAME%" already created
	goto end
)
echo Creating service %SERVICE_NAME% binPath= "%~dp0%SERVICE_EXE_FILE%"
sc create %SERVICE_NAME% binPath= "%~dp0%SERVICE_EXE_FILE% --server/service/enabled 1" start= auto
if %ERRORLEVEL% NEQ 0 (
	echo Cannot create service "%SERVICE_NAME%"
	goto end_error
)
goto service_start
goto end

:service_start
sc queryex type= service state= all | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% NEQ 0 (
	echo Service "%SERVICE_NAME%" not found
	goto end_error
)
sc queryex type= service state= active | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% EQU 0 (
	echo Service "%SERVICE_NAME%" already is active
	goto end
)
echo Starting service "%SERVICE_NAME%"
sc start %SERVICE_NAME%
if %ERRORLEVEL% NEQ 0 (
	echo Cannot start service "%SERVICE_NAME%"
	goto end_error
)
goto end

:service_stop
sc queryex type= service state= all | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% NEQ 0 (
	echo Service "%SERVICE_NAME%" not found
	goto end_error
)
sc queryex type= service state= inactive | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% EQU 0 (
	echo Service "%SERVICE_NAME%" is already inactive
	goto end
)
echo Stopping service %SERVICE_NAME%
sc stop %SERVICE_NAME%
if %ERRORLEVEL% NEQ 0 (
	echo Cannot stop service "%SERVICE_NAME%"
	goto end_error
)
goto end

:service_delete
call :check_privileges
sc queryex type= service state= all | find /i ": %SERVICE_NAME%"
if %ERRORLEVEL% NEQ 0 (
	echo Service %SERVICE_NAME% not exist
	goto end
)
sc queryex %SERVICE_NAME% | find /i "STOPPED"
if %ERRORLEVEL% EQU 0 (
	goto delete
)
echo Stopping service %SERVICE_NAME%
sc stop %SERVICE_NAME%
if %ERRORLEVEL% NEQ 0 (
	echo Cannot stop service "%SERVICE_NAME%"
	goto end_error
)
:delete
sc delete %SERVICE_NAME%
if %ERRORLEVEL% NEQ 0 (
	echo Cannot delete service "%SERVICE_NAME%"
	goto end_error
)
goto end

:service_status
sc queryex %SERVICE_NAME%
goto end

:check_privileges
echo Check administrator privileges...
net file 1>nul 2>nul
if "%errorlevel%" NEQ "0" (
	echo Administrator privileges required
	goto end_error
)
exit /B 0
:end
exit /B 0
:end_error
echo Resolve described issue
exit /B 1