/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import jep.ClassEnquirer;
import jep.ClassFilenameFilter;
import jep.Jep;
import jep.JepException;

public class ClassList
implements ClassEnquirer {
    private static ClassList inst;
    private Map<String, List<String>> packageToClassMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> packageToSubPackageMap = new HashMap<String, List<String>>();

    private ClassList() throws JepException {
        this.loadClassPath();
        this.loadPackages();
        this.loadClassList();
        for (String string : ClassEnquirer.RESTRICTED_PKG_NAMES) {
            this.packageToClassMap.remove(string);
            this.packageToSubPackageMap.remove(string);
        }
    }

    private void loadClassPath() {
        String string;
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            linkedList.add(string);
            hashSet.add(string);
        }
        while (!linkedList.isEmpty()) {
            string = (String)linkedList.remove();
            File file = new File(string);
            if (!file.exists() || !file.canRead()) continue;
            if (file.isDirectory()) {
                this.addClassFilesInTree(file, "");
                continue;
            }
            if (!string.toLowerCase().endsWith(".jar")) continue;
            try {
                JarFile jarFile = new JarFile(string, false);
                Throwable throwable = null;
                try {
                    Object object;
                    Object object2;
                    Manifest manifest = jarFile.getManifest();
                    if (manifest != null && (object2 = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        Object object3 = object = ((String)object2).split(" ");
                        int n = ((Object)object3).length;
                        for (int i = 0; i < n; ++i) {
                            Object object4;
                            Object object5 = object4 = object3[i];
                            String string2 = file.getParent();
                            if (string2 != null) {
                                object5 = string2 + File.separator + (String)object4;
                            }
                            if (hashSet.contains(object5)) continue;
                            linkedList.add(object5);
                            hashSet.add(object5);
                        }
                    }
                    object2 = jarFile.entries();
                    while (object2.hasMoreElements()) {
                        int n;
                        object = ((JarEntry)object2.nextElement()).getName();
                        if (!((String)object).toLowerCase().endsWith(".class") || (n = ((String)object).lastIndexOf(47)) < 0) continue;
                        String string3 = ((String)object).substring(0, n).replace('/', '.');
                        String string4 = this.stripClassExt(((String)object).substring(n + 1));
                        if (string4.contains("$")) continue;
                        this.addClass(string3, string4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarFile == null) continue;
                    if (throwable != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jarFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void addClassFilesInTree(File file, String string) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("folder is not a Directory");
        }
        for (File file2 : file.listFiles()) {
            String string2 = file2.getName();
            if (file2.isDirectory()) {
                if (string != null && !string.isEmpty()) {
                    this.addClassFilesInTree(file2, string + "." + string2);
                    continue;
                }
                this.addClassFilesInTree(file2, string2);
                continue;
            }
            if (!file2.exists() || !file2.canRead() || !string2.toLowerCase().endsWith(".class")) continue;
            this.addClass(string, string2.replaceAll(".class$", ""));
        }
    }

    private void loadPackages() throws JepException {
        Package[] packageArray;
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (Package package_ : packageArray = Package.getPackages()) {
            String string = package_.getName().replace('.', '/');
            URL uRL = classLoader.getResource(string);
            if (uRL == null || !uRL.getProtocol().equals("file")) continue;
            File file = null;
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new JepException(uRISyntaxException);
            }
            for (File file2 : file.listFiles(new ClassFilenameFilter())) {
                this.addClass(package_.getName(), this.stripClassExt(file2.getName()));
            }
        }
    }

    private String stripClassExt(String string) {
        return string.substring(0, string.length() - 6);
    }

    private void loadClassList() throws JepException {
        String string = System.getProperty("java.version");
        boolean bl = Thread.currentThread() != null && Thread.currentThread().getContextClassLoader() != null;
        ClassLoader classLoader = bl ? Thread.currentThread().getContextClassLoader() : ClassLoader.getSystemClassLoader();
        ClassLoader[] classLoaderArray = new ClassLoader[]{classLoader, Jep.class.getClassLoader()};
        String string2 = "jep/classlist_";
        string2 = string.startsWith("1.8") ? string2 + "8" : (string.startsWith("9.") ? string2 + "9" : (string.startsWith("10.") ? string2 + "10" : string2 + "11"));
        string2 = string2 + ".txt";
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        ClassLoader classLoader2 = null;
        try {
            int n;
            for (n = 0; inputStream == null && n < classLoaderArray.length; ++n) {
                classLoader2 = classLoaderArray[n];
                inputStream = classLoader2.getResourceAsStream(string2);
            }
            if (inputStream == null) {
                throw new JepException("ClassList couldn't find resource " + string2);
            }
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string3 = "";
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(36) > -1) continue;
                String[] stringArray = string3.split("\\/");
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = stringArray[stringArray.length - 1];
                for (n = 0; n < stringArray.length - 1; ++n) {
                    stringBuilder.append(stringArray[n]);
                    if (n >= stringArray.length - 2) continue;
                    stringBuilder.append(".");
                }
                this.addClass(stringBuilder.toString(), string4);
            }
        }
        catch (IOException iOException) {
            throw new JepException(iOException);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addClass(String string, String string2) {
        String string3;
        List<String> list = this.packageToClassMap.get(string);
        if (list == null) {
            list = new ArrayList<String>();
            this.packageToClassMap.put(string, list);
        }
        if (!list.contains(string3 = string + "." + string2)) {
            list.add(string3);
        }
        int n = string.indexOf(".");
        while (n > -1) {
            String string4 = string.substring(0, n);
            int n2 = string.indexOf(".", n + 1);
            String string5 = null;
            string5 = n2 > -1 ? string.substring(n + 1, n2) : string.substring(n + 1);
            List<String> list2 = this.packageToSubPackageMap.get(string4);
            if (list2 == null) {
                list2 = new ArrayList<String>();
                this.packageToSubPackageMap.put(string4, list2);
            }
            if (!list2.contains(string5)) {
                list2.add(string5);
            }
            n = n2;
        }
    }

    @Override
    public String[] getClassNames(String string) {
        List<String> list = this.packageToClassMap.get(string);
        if (list == null) {
            return new String[0];
        }
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    @Override
    public String[] getSubPackages(String string) {
        List<String> list = this.packageToSubPackageMap.get(string);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    @Override
    public boolean isJavaPackage(String string) {
        return this.packageToClassMap.containsKey(string) || this.packageToSubPackageMap.containsKey(string);
    }

    public static synchronized ClassList getInstance() throws JepException {
        if (inst == null) {
            inst = new ClassList();
        }
        return inst;
    }

    public static void main(String[] stringArray) throws Throwable {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                for (String string2 : ClassList.getInstance().getClassNames(string)) {
                    System.out.println(string2);
                }
            }
        } else {
            for (String string : ClassList.getInstance().getClassNames("java.lang")) {
                System.out.println(string);
            }
            for (String string : ClassList.getInstance().getClassNames("jep")) {
                System.out.println(string);
            }
        }
    }
}

