/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.url;

import com.siams.stare.api.url.UrlBuilder;
import com.siams.stare.api.url.UrlParserError;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class UrlParser {
    private final String url;
    private String[] items = null;
    private static final Root root = new Root();
    private String path = null;

    public UrlParser(String url) {
        this.url = url;
    }

    private void parse() {
        if (this.items != null) {
            return;
        }
        this.checkUrlCorrectness();
        this.items = this.url.split("[\\/:]");
    }

    private void checkUrlCorrectness() {
        if (this.url.isBlank()) {
            throw new UrlParserError("Blank url not allowed");
        }
        if (!this.url.startsWith("/")) {
            throw new UrlParserError("Url should start with '/'");
        }
        int idx = 0;
        int size = this.url.length();
        Node node = root;
        while (idx < size) {
            if (this.url.charAt(idx) != '/') {
                throw new UrlParserError(String.format("Incorrect url (%s), expected '/' at %d", this.url, idx));
            }
            ++idx;
            boolean found = false;
            for (Node c2 : node.childs) {
                if (!this.url.startsWith(c2.name, idx)) continue;
                idx += c2.name.length() - 1;
                node = c2;
                found = true;
                break;
            }
            if (!found) {
                throw new UrlParserError(String.format("Incorrect url (%s) at: %d, expected: %s ", this.url, idx, node.childs.stream().map(c -> c.name).collect(Collectors.joining(","))));
            }
            if (++idx >= size) continue;
            if (this.url.charAt(idx) != ':') {
                throw new UrlParserError(String.format("Incorrect url (%s), expected ':' at %d", this.url, idx));
            }
            int i = this.url.indexOf("/", idx);
            if (i != -1) {
                idx = i;
                continue;
            }
            idx = this.url.length();
        }
    }

    public String getSessionId() {
        return this.getItem(2);
    }

    public String getProjectId() {
        return this.getItem(4);
    }

    public String getErrorId() {
        return this.getItem(6);
    }

    public Optional<String> optProjectId() {
        return this.optItem(4);
    }

    public String getModelId() {
        return this.getItem(2);
    }

    public String getProjectModelId() {
        return this.getItem(6);
    }

    public String getProjectWorkerId() {
        return this.getItem(6);
    }

    public String getProjectWorkerPropertyId() {
        return this.getItem(8);
    }

    public String getProjectLinkId() {
        return this.getItem(6);
    }

    public String getProjectPropertyId() {
        return this.getItem(6);
    }

    public String getProjectInputId() {
        return this.getItem(6);
    }

    public String getProjectOutputId() {
        return this.getItem(6);
    }

    public String getProjectSettingId() {
        return this.getItem(6);
    }

    private String getItem(int idx) {
        this.parse();
        return this.items[idx];
    }

    private Optional<String> optItem(int idx) {
        this.parse();
        return Optional.ofNullable(this.items.length > idx ? this.items[idx] : null);
    }

    private String getPath() {
        this.parse();
        if (this.path != null) {
            return this.path;
        }
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 1; i < this.items.length; i += 2) {
            list.add(this.items[i]);
        }
        return "/" + String.join((CharSequence)"/", list);
    }

    public boolean pathEqualsSession() {
        return this.getPath().equals(UrlBuilder.session());
    }

    public boolean pathEqualsSessionProject() {
        return this.getPath().equals(UrlBuilder.sessionProject());
    }

    public boolean pathEqualsSessionProjectWorkerProperty() {
        return this.getPath().equals(UrlBuilder.sessionProjectWorkerProperty());
    }

    public boolean pathEqualsSessionProjectInput() {
        return this.getPath().equals(UrlBuilder.sessionProjectInput());
    }

    public boolean pathEqualsSessionProjectData() {
        return this.getPath().equals(UrlBuilder.sessionProjectData());
    }

    public boolean pathEqualsSessionProjectProperty() {
        return this.getPath().equals(UrlBuilder.sessionProjectProperty());
    }

    public boolean pathEqualsSessionProjectOutput() {
        return this.getPath().equals(UrlBuilder.sessionProjectOutput());
    }

    public boolean pathEqualsSessionProjectError() {
        return this.getPath().equals(UrlBuilder.sessionProjectError());
    }

    private static class Root
    extends Node {
        private Root() {
            super("", new Model(), new Session());
        }
    }

    private static class Node {
        public final String name;
        public final List<Node> childs;

        private Node(String name) {
            this.name = name;
            this.childs = Collections.emptyList();
        }

        private Node(String name, Node ... childs) {
            this.name = name;
            this.childs = Arrays.asList(childs);
        }
    }

    private static class Setting
    extends Node {
        private Setting() {
            super("setting");
        }
    }

    private static class Output
    extends Node {
        private Output() {
            super("output");
        }
    }

    private static class Data
    extends Node {
        private Data() {
            super("data");
        }
    }

    private static class Input
    extends Node {
        private Input() {
            super("input");
        }
    }

    private static class Property
    extends Node {
        private Property() {
            super("property");
        }
    }

    private static class Link
    extends Node {
        private Link() {
            super("link");
        }
    }

    private static class Worker
    extends Node {
        private Worker() {
            super("worker", new Property());
        }
    }

    private static class Error
    extends Node {
        private Error() {
            super("error");
        }
    }

    private static class Project
    extends Node {
        private Project() {
            super("project", new Error(), new Model(), new Worker(), new Link(), new Property(), new Input(), new Data(), new Output(), new Setting());
        }
    }

    private static class Session
    extends Node {
        private Session() {
            super("session", new Project());
        }
    }

    private static class Model
    extends Node {
        private Model() {
            super("model");
        }
    }
}

