/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.data.setting;

import com.siams.stare.api.data.Control;
import com.siams.stare.api.data.setting.Setting;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SettingTree {
    private List<Setting> items = new LinkedList<Setting>();
    public static final String LEAF_ID_ROOT = "root";
    public static final String LEAF_ID_INPUTS = "inputs";
    public static final String LEAF_ID_SETTINGS = "settings";
    public static final String LEAF_ID_OUTPUTS = "outputs";
    public static final String LEAF_ID_DATA = "data";
    public Setting root = new Setting("root", "root", "");

    public SettingTree() {
        this.items.add(new Setting(LEAF_ID_INPUTS, LEAF_ID_INPUTS, LEAF_ID_ROOT));
        this.items.add(new Setting(LEAF_ID_SETTINGS, LEAF_ID_SETTINGS, LEAF_ID_ROOT));
        this.items.add(new Setting(LEAF_ID_OUTPUTS, LEAF_ID_OUTPUTS, LEAF_ID_ROOT));
        this.items.add(new Setting(LEAF_ID_DATA, LEAF_ID_DATA, LEAF_ID_ROOT));
    }

    private Setting getPredefinedLeaf(String name) {
        return this.root.child.stream().filter(setting -> setting.name.equals(name)).findFirst().get();
    }

    public Setting getInputsLeaf() {
        return this.getPredefinedLeaf(LEAF_ID_INPUTS);
    }

    public Setting getOutputsLeaf() {
        return this.getPredefinedLeaf(LEAF_ID_OUTPUTS);
    }

    public Setting getSettingsLeaf() {
        return this.getPredefinedLeaf(LEAF_ID_SETTINGS);
    }

    public Setting getDataLeaf() {
        return this.getPredefinedLeaf(LEAF_ID_DATA);
    }

    private void buildTree(Setting parent) {
        for (Setting child : this.items) {
            if (!child.parentId.equals(parent.id)) continue;
            parent.child.add(child);
            child.parent = parent;
            this.buildTree(child);
        }
    }

    public void buildTree() {
        this.buildTree(this.root);
        this.dive(setting -> {
            String parentPath = setting.getPath();
            setting.controls.forEach(control -> {
                control.path = String.format("%s/%s", parentPath, control.name);
            });
        });
        this.items.clear();
    }

    public void addItem(Setting node) {
        this.items.add(node);
    }

    private void forEach(Consumer<Setting> visitor, Setting item) {
        for (Setting child : item.child) {
            visitor.accept(child);
            this.forEach(visitor, child);
        }
    }

    private <T> T forEach(Function<Setting, T> visitor, Setting item) {
        for (Setting child : item.child) {
            T result = visitor.apply(child);
            if (result != null) {
                return result;
            }
            result = this.forEach(visitor, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void dive(Consumer<Setting> visitor) {
        this.forEach(visitor, this.root);
    }

    public Optional<Control> findControlByPath(String path) {
        return Optional.ofNullable(this.root.dive(true, setting -> setting.findControlByPath(path).orElse(null)));
    }

    public Optional<Setting> findSettingByPath(String path) {
        return Optional.ofNullable(this.root.dive(true, setting -> setting.getPath().equals(path) ? setting : null));
    }
}

