/*
 * Decompiled with CFR 0.152.
 */
package com.siams.stare.api.data.setting;

import com.siams.stare.api.data.Control;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Function;

public class Setting {
    public String url = "";
    public String id = "";
    public String name = "";
    public String description = "";
    public String modelId = "";
    public String modelUrl = "";
    public String parentId = "";
    public List<Setting> child = new LinkedList<Setting>();
    public Setting parent = null;
    public List<Control> controls = Collections.emptyList();
    private String path = null;

    public Setting() {
    }

    public Setting(String id, String name, String parentId) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
    }

    public String toString() {
        return "Setting{url='" + this.url + "', id='" + this.id + "', name='" + this.name + "'}";
    }

    private void dive(Setting parent, Consumer<Setting> visitor) {
        for (Setting node : parent.child) {
            visitor.accept(node);
            this.dive(node, visitor);
        }
    }

    public void dive(boolean includeThis, Consumer<Setting> visitor) {
        if (includeThis) {
            visitor.accept(this);
        }
        this.dive(this, visitor);
    }

    public void bobUp(boolean includeThis, Consumer<Setting> visitor) {
        if (includeThis) {
            visitor.accept(this);
        }
        Setting parent = this.parent;
        while (parent != null) {
            visitor.accept(parent);
            parent = parent.parent;
        }
    }

    public String getPath() {
        if (this.path != null) {
            return this.path;
        }
        Stack<String> namesStack = new Stack<String>();
        namesStack.add(this.name);
        Setting parent = this.parent;
        while (parent != null) {
            namesStack.push(parent.name);
            parent = parent.parent;
        }
        StringBuilder result = new StringBuilder();
        while (!namesStack.empty()) {
            String name = (String)namesStack.pop();
            result.append("/");
            result.append(name);
        }
        this.path = result.toString();
        return this.path;
    }

    public Optional<Control> findControlByPath(String path) {
        return this.controls.stream().filter(control -> {
            String controlPath = this.getPath() + "/" + control.name;
            return controlPath.equals(path);
        }).findFirst();
    }

    private <T> T dive(Function<Setting, T> visitor, Setting item) {
        for (Setting child : item.child) {
            T result = visitor.apply(child);
            if (result != null) {
                return result;
            }
            result = this.dive(visitor, child);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public <T> T dive(boolean includeThis, Function<Setting, T> visitor) {
        T result = null;
        if (includeThis && (result = (T)visitor.apply(this)) != null) {
            return result;
        }
        return this.dive(visitor, this);
    }

    public Optional<Setting> findSettingByPath(String path) {
        return Optional.ofNullable(this.dive(true, (Setting setting) -> setting.getPath().equals(path) ? setting : null));
    }
}

