/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.algart.arrays.Matrix;
import net.algart.executors.api.data.SMat;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;

public class MergeSplitChannelsTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.printf("Usage: %s some_image.png image_folder%n", MergeSplitChannelsTest.class);
            return;
        }
        Path sourceFile = Paths.get(args[0], new String[0]);
        Path imageFolder = Paths.get(args[1], new String[0]);
        BufferedImage image = MatrixIO.readBufferedImage((Path)sourceFile);
        MultiMatrix multiMatrix = SMat.of((BufferedImage)image).toMultiMatrix();
        Matrix matrix = multiMatrix.mergeChannels();
        MatrixIO.writeImageFolder((Path)imageFolder, List.of(matrix));
        MultiMatrix unpackedChannels = MultiMatrix.ofMerged((Matrix)matrix);
        if (!unpackedChannels.dimEquals(multiMatrix)) {
            throw new AssertionError((Object)"Dimensions mismatch!");
        }
        for (int k = 0; k < multiMatrix.numberOfChannels(); ++k) {
            if (!multiMatrix.channel(k).equals((Object)unpackedChannels.channel(k))) {
                throw new AssertionError((Object)("Channels #" + k + " mismatch!"));
            }
        }
    }
}

