/*
 * Decompiled with CFR 0.152.
 */
package net.algart.multimatrix;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import net.algart.executors.api.data.SMat;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public class GetSetPixelsTest {
    public static void main(String[] args) throws IOException {
        long x;
        long y;
        if (args.length < 1) {
            System.out.printf("Usage: %s result_image.png%n", GetSetPixelsTest.class);
            return;
        }
        String fileName = args[0];
        double[] color = new double[]{1.0, 1.0, 0.0};
        MultiMatrix2D m = MultiMatrix.newMultiMatrix2D(Double.TYPE, (int)3, (long)300L, (long)200L);
        for (y = 0L; y < m.dimY(); ++y) {
            for (x = 0L; x < m.dimX(); ++x) {
                for (int k = 0; k < m.numberOfChannels(); ++k) {
                    double value = color[k] * (double)(x + y) / 300.0;
                    m.setPixelChannel(k, x, y, value);
                    if (m.getPixelChannel(k, x, y) != value) {
                        throw new AssertionError((Object)(k + "; " + x + ", " + y + ": " + m.getPixelChannel(k, x, y) + "!=" + value));
                    }
                }
            }
        }
        for (y = 0L; y < m.dimY(); ++y) {
            for (x = 0L; x < m.dimX(); ++x) {
                MultiMatrix.PixelValue pixel = m.getPixel(m.indexInArray(x, y));
                for (int k = 0; k < m.numberOfChannels(); ++k) {
                    if (pixel.getChannel(k) != m.getPixelChannel(k, x, y)) {
                        throw new AssertionError((Object)(k + "; " + x + ", " + y + ": " + m.getPixelChannel(k, x, y) + "!=" + pixel.getChannel(k)));
                    }
                }
                m.setPixel(m.indexInArray(x, y), pixel);
            }
        }
        BufferedImage image = SMat.of((MultiMatrix)m).toBufferedImage();
        System.out.printf("Writing %s%n", fileName);
        assert (image != null);
        MatrixIO.writeBufferedImage((Path)Path.of(fileName, new String[0]), (BufferedImage)image);
        for (Class elementType : MultiMatrix.SUPPORTED_ELEMENT_TYPES) {
            System.out.printf("Pixel at the center: %s (in %s)%n", m.asPrecision(elementType).getPixel(m.dimX() / 2L, m.dimY() / 2L), m);
        }
    }
}

