/*
 * Decompiled with CFR 0.152.
 */
package net.algart.misc;

public class MemoryUsageTest {
    private static final int COUNT = 0x100000;

    private static void showMemory(String message) {
        System.gc();
        Runtime rt = Runtime.getRuntime();
        for (int k = 0; k < 10; ++k) {
            System.gc();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            rt.freeMemory();
        }
        System.out.printf("%s: %.2f/%.2f MB, %.4f bytes/element%n", message, (double)(rt.totalMemory() - rt.freeMemory()) * 1.0E-6, (double)rt.maxMemory() * 1.0E-6, (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0);
    }

    private static void test1() {
        MemoryUsageTest.showMemory("Nothing");
        float[] data = new float[0x100000];
        MemoryUsageTest.showMemory("float[]");
        System.out.println();
    }

    private static void test2() {
        MemoryUsageTest.showMemory("Nothing");
        SimplestFloat[] data = new SimplestFloat[0x100000];
        MemoryUsageTest.showMemory("null[]");
        for (int k = 0; k < 0x100000; ++k) {
            data[k] = new SimplestFloat();
        }
        MemoryUsageTest.showMemory("SimplestFloat[]");
        double sum = 0.0;
        for (int k = 0; k < 0x100000; ++k) {
            sum += (double)data[k].a;
        }
        System.out.println(sum);
        System.out.println();
    }

    private static void test3() {
        MemoryUsageTest.showMemory("Nothing");
        SimplestDouble[] data = new SimplestDouble[0x100000];
        MemoryUsageTest.showMemory("null[]");
        for (int k = 0; k < 0x100000; ++k) {
            data[k] = new SimplestDouble();
        }
        MemoryUsageTest.showMemory("SimplestDouble[]");
        double sum = 0.0;
        for (int k = 0; k < 0x100000; ++k) {
            sum += data[k].a;
        }
        System.out.println(sum);
        System.out.println();
    }

    private static void test4() {
        MemoryUsageTest.showMemory("Nothing");
        Float10[] data = new Float10[0x100000];
        MemoryUsageTest.showMemory("null[]");
        for (int k = 0; k < 0x100000; ++k) {
            data[k] = new Float10();
        }
        MemoryUsageTest.showMemory("Float10[]");
        double sum = 0.0;
        for (int k = 0; k < 0x100000; ++k) {
            sum += data[k].sum();
        }
        System.out.println(sum);
        System.out.println();
    }

    private static void test5() {
        MemoryUsageTest.showMemory("Nothing");
        Float100[] data = new Float100[0x100000];
        MemoryUsageTest.showMemory("null[]");
        for (int k = 0; k < 0x100000; ++k) {
            data[k] = new Float100();
        }
        MemoryUsageTest.showMemory("Float100[]");
        double sum = 0.0;
        for (int k = 0; k < 0x100000; ++k) {
            sum += data[k].sum();
        }
        System.out.println(sum);
        System.out.println();
    }

    public static void main(String[] args) {
        for (int testIndex = 1; testIndex <= 5; ++testIndex) {
            System.out.printf("%nTest #%d%n", testIndex);
            MemoryUsageTest.test1();
            MemoryUsageTest.test2();
            MemoryUsageTest.test3();
            MemoryUsageTest.test4();
            MemoryUsageTest.test5();
        }
    }

    private static class SimplestFloat {
        float a;

        private SimplestFloat() {
        }
    }

    private static class SimplestDouble {
        double a;

        private SimplestDouble() {
        }
    }

    private static class Float10 {
        float[] a = new float[10];
        double v;

        private Float10() {
        }

        public double sum() {
            double sum = this.v;
            for (float v : this.a) {
                sum += (double)v;
            }
            return sum;
        }
    }

    private static class Float100 {
        float[] a = new float[100];

        private Float100() {
        }

        public double sum() {
            double sum = 0.0;
            for (float v : this.a) {
                sum += (double)v;
            }
            return sum;
        }
    }
}

