/*
 * Decompiled with CFR 0.152.
 */
package net.algart.json;

import jakarta.json.Json;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import net.algart.json.Jsons;

public class CommonJsonTest {
    public static void main(String[] args) {
        JsonString stringValue = Jsons.stringValue((String)"");
        JsonNumber intValue = Jsons.intValue((int)123);
        JsonNumber longValue = Jsons.longValue((long)Long.MAX_VALUE);
        JsonNumber doubleValue = Jsons.doubleValue((double)1.1);
        JsonValue booleanValue = Jsons.booleanValue((boolean)false);
        System.out.println(stringValue);
        System.out.printf("String: %s = %s%n", stringValue, stringValue);
        System.out.printf("int: %s = %s%n", intValue, intValue.intValue());
        System.out.printf("long: %s = %s%n", longValue, longValue.longValue());
        System.out.printf("double: %s = %s%n", doubleValue, doubleValue.doubleValue());
        System.out.printf("boolean: %s (%s)%n", booleanValue, booleanValue == JsonValue.FALSE ? "==FALSE" : "!=FALSE");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("String", (JsonValue)stringValue);
        builder.add("int", (JsonValue)intValue);
        builder.add("long", (JsonValue)longValue);
        builder.add("double", (JsonValue)doubleValue);
        builder.add("boolean", booleanValue);
        builder.add("object", (JsonValue)Jsons.newEmptyJson());
        JsonObject json = builder.build();
        System.out.println(Jsons.toPrettyString((JsonObject)json));
        System.out.println(Jsons.getJsonObject((JsonObject)json, (String)"long_"));
        System.out.println(Jsons.getJsonObject(null, (String)"long_"));
        System.out.println();
        builder = Json.createObjectBuilder();
        Jsons.addDouble((JsonObjectBuilder)builder, (String)"negative_infinity", (double)Double.NEGATIVE_INFINITY);
        Jsons.addDouble((JsonObjectBuilder)builder, (String)"positive_infinity", (double)Double.POSITIVE_INFINITY);
        Jsons.addDouble((JsonObjectBuilder)builder, (String)"mot-a-number", (double)Double.NaN);
        Jsons.addDouble((JsonObjectBuilder)builder, (String)"157", (double)157.0);
        Jsons.addDouble((JsonObjectBuilder)builder, (String)"max_value", (double)Double.MAX_VALUE);
        builder.add("boolean", true);
        json = builder.build();
        System.out.println(Jsons.toPrettyString((JsonObject)json));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"negative_infinity", (double)-1.0));
        System.out.println(Jsons.reqDouble((JsonObject)json, (String)"negative_infinity"));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"positive_infinity", (double)-1.0));
        System.out.println(Jsons.reqDouble((JsonObject)json, (String)"positive_infinity"));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"mot-a-number", (double)-1.0));
        System.out.println(Jsons.reqDouble((JsonObject)json, (String)"mot-a-number"));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"157", (double)-1.0));
        System.out.println(Jsons.reqDouble((JsonObject)json, (String)"157"));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"max_value", (double)-1.0));
        System.out.println(Jsons.reqDouble((JsonObject)json, (String)"max_value"));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"xxxxxxxxx", (double)-1.0));
        System.out.println(Jsons.getDouble((JsonObject)json, (String)"boolean", (double)-1.0));
    }
}

