/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.tests;

import java.io.FileNotFoundException;
import java.nio.file.Paths;
import jep.ClassList;
import jep.Interpreter;
import jep.JepConfig;
import jep.JepException;
import jep.SharedInterpreter;

public class SimpleJepForImport {
    private static void tryToImport(Interpreter interp, String moduleName) {
        SimpleJepForImport.tryToImport(interp, moduleName, null);
    }

    private static void tryToImport(Interpreter interp, String moduleName, String from) {
        try {
            System.out.printf("Importing %s%s (isJavaPackage: %s)...%n", moduleName, from == null ? "" : " from " + from, ClassList.getInstance().isJavaPackage(moduleName));
            interp.exec((String)(from == null ? "" : "from " + from + " ") + "import " + moduleName);
        }
        catch (JepException e) {
            System.out.println((Object)e);
        }
    }

    private static void correctClassLoader(Thread thread) {
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        if (contextClassLoader == null) {
            thread.setContextClassLoader(SimpleJepForImport.class.getClassLoader());
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        SimpleJepForImport.correctClassLoader(Thread.currentThread());
        String root = "src/test/resources/python_tests";
        String root2 = args.length < 1 ? null : Paths.get(args[0], new String[0]).toAbsolutePath().toString();
        System.out.printf("Adding new root: %s%n", "src/test/resources/python_tests");
        JepConfig config = new JepConfig();
        config.addIncludePaths(new String[]{"src/test/resources/python_tests"});
        if (root2 != null) {
            config.addIncludePaths(new String[]{root2});
        }
        SharedInterpreter.setConfig((JepConfig)config);
        SharedInterpreter interp = new SharedInterpreter();
        SimpleJepForImport.tryToImport((Interpreter)interp, SimpleJepForImport.class.getSimpleName(), SimpleJepForImport.class.getPackageName());
        SimpleJepForImport.tryToImport((Interpreter)interp, "tests.SimpleTest");
        SimpleJepForImport.tryToImport((Interpreter)interp, "algart");
        SimpleJepForImport.tryToImport((Interpreter)interp, "algart.api");
        SimpleJepForImport.tryToImport((Interpreter)interp, "net");
        SimpleJepForImport.tryToImport((Interpreter)interp, "net.algart");
        SimpleJepForImport.tryToImport((Interpreter)interp, "net.algart.pyth");
        SimpleJepForImport.tryToImport((Interpreter)interp, "net.algart.pyth.api");
        SimpleJepForImport.tryToImport((Interpreter)interp, "net.algart.pyth.api.my_lib");
    }
}

