/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;

public class GraalVMSimpleDemo {
    public void testUsual() {
        System.out.println("testUsual");
    }

    public static Context callJs() {
        Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).build();
        String source = "let a = 5;\nlet b = 10;\njava.lang.System.out.println(a + b);\na * b";
        Value result = context.eval("js", (CharSequence)source);
        System.out.println("result: " + String.valueOf(result));
        return context;
    }

    public static void callPython() {
        try (Context context = Context.newBuilder((String[])new String[]{"python"}).allowAllAccess(true).build();){
            String source = "a = 5;\nb = 10;\nprint(a + b);\na * b";
            Value result = context.eval("python", (CharSequence)source);
            System.out.println("result: " + String.valueOf(result));
        }
    }

    public static void callPythonNumpy() {
        try (Context context = Context.newBuilder((String[])new String[]{"python"}).allowAllAccess(true).build();){
            context.eval("python", (CharSequence)"import numpy as np");
            context.eval("python", (CharSequence)"arr = np.array([1, 2, 3, 4, 5])");
            context.eval("python", (CharSequence)"sum_arr = np.sum(arr)");
            Value sumValue = context.eval("python", (CharSequence)"sum_arr");
            int sum = sumValue.asInt();
            System.out.println("Sum from Python (NumPy): " + sum);
            Value pythonFunction = context.eval("python", (CharSequence)"def process_data(data):\n    import numpy as np\n    np_data = np.array(data)\n    result = np_data * 2\n    return result.tolist()");
            Value javaList = context.asValue((Object)new int[]{10, 20, 30});
            Value pythonResult = pythonFunction.execute(new Object[]{javaList});
            List resultList = (List)pythonResult.as(List.class);
            System.out.println("Result Python: " + String.valueOf(resultList));
        }
    }

    public static void main(String[] args) {
        Runtime rt = Runtime.getRuntime();
        ArrayList<Context> contexts = new ArrayList<Context>();
        for (int k = 1; k < 100; ++k) {
            System.out.printf("Iteration %d...%n", k);
            long t1 = System.nanoTime();
            Context context = GraalVMSimpleDemo.callJs();
            contexts.add(context);
            long t2 = System.nanoTime();
            System.out.printf("Creating context: %.3f ms, used memory: %.5f MB / %.5f MB%n", (double)(t2 - t1) * 1.0E-6, (double)(rt.totalMemory() - rt.freeMemory()) / 1048576.0, (double)rt.maxMemory() / 1048576.0);
        }
    }
}

