/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalVMLiteralOrFileTest {
    public static void main(String[] args) throws ScriptException, IOException {
        Path currentDirectory = Paths.get("src/test/java/net/algart/graalvm/tests", new String[0]);
        String moduleFile = "./js/sometest.mjs";
        Path modulePath = currentDirectory.resolve(Paths.get("./js/sometest.mjs", new String[0]));
        System.out.println("Loading " + String.valueOf(modulePath.toAbsolutePath()));
        String src = "import {test} from './js/sometest.mjs';\ntest";
        Context context = Context.newBuilder((String[])new String[]{"js"}).allowAllAccess(true).currentWorkingDirectory(currentDirectory.toAbsolutePath()).build();
        Source sourceLiteral = Source.newBuilder((String)"js", (CharSequence)src, (String)"test.mjs").buildLiteral();
        System.out.printf("Evaluating literal:%n*****%n%s%n*****%n", sourceLiteral.getCharacters());
        System.out.println("Name: " + sourceLiteral.getName());
        System.out.println("Language: " + sourceLiteral.getLanguage());
        Source sourceLiteralOther = Source.newBuilder((String)"js", (CharSequence)src, (String)"test.js").buildLiteral();
        System.out.println("Equality to other literal: " + sourceLiteral.equals((Object)sourceLiteralOther));
        System.out.println();
        Value func = context.eval(sourceLiteral);
        System.out.println("Function: " + String.valueOf(func));
        System.out.println();
        System.out.println("Caling function");
        int[] intArray = new int[]{11, 12, 13};
        Value execute = func.execute(new Object[]{intArray});
        System.out.println("Function result: " + String.valueOf(execute));
        System.out.println();
        System.out.println();
        File file = modulePath.toFile();
        Source sourceInFile = Source.newBuilder((String)"js", (File)file).build();
        System.out.printf("Evaluating file:%n*****%n%s%n*****%n", sourceInFile.getCharacters());
        System.out.println("Name: " + sourceInFile.getName());
        System.out.println("Language: " + sourceInFile.getLanguage());
        Source sourceInFileOther = Source.newBuilder((String)"js", (File)file).build();
        System.out.println("Equality to other file: " + sourceInFile.equals((Object)sourceInFileOther));
        System.out.println();
        func = context.eval(sourceInFile);
        System.out.println("Function: " + String.valueOf(func));
        System.out.println();
        System.out.println("Caling function");
        execute = func.execute(new Object[0]);
        System.out.println("Function result: " + String.valueOf(execute));
    }
}

