/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import java.io.IOException;
import javax.script.ScriptException;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;

public class GraalSourceModuleSimpleTest {
    private static final String source = "export function simpleTest() {\n    return \"Hello!\";\n}\nsimpleTest\n";

    public static void main(String[] args) throws ScriptException, IOException {
        boolean useReturnExports = args.length > 0 && args[0].equals("exports");
        System.out.println("useReturnExports: " + useReturnExports);
        Source.Builder sourceBuilder = Source.newBuilder((String)"js", (CharSequence)source, (String)"myTest");
        sourceBuilder.mimeType("application/javascript+module");
        Source source = sourceBuilder.build();
        Context.Builder contextBuilder = Context.newBuilder((String[])new String[]{"js"});
        if (useReturnExports) {
            contextBuilder.option("js.esm-eval-returns-exports", "true");
        }
        try (Context context = contextBuilder.build();){
            Value module = context.eval(source);
            System.out.println("Module/last line: " + String.valueOf(module));
            Value func = module.getMember("simpleTest");
            if (func == null) {
                func = module;
            }
            System.out.println("Function simpleTest: " + String.valueOf(func));
            Value funcSecond = module.getMember("toJsonString");
            System.out.println("Function toJsonString: " + String.valueOf(funcSecond));
            Value result = func.execute(new Object[0]);
            System.out.println("execute result: " + String.valueOf(result));
        }
    }
}

