/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm.tests;

import javax.script.ScriptException;
import net.algart.executors.api.graalvm.GraalAPI;
import net.algart.executors.api.graalvm.GraalSafety;
import net.algart.graalvm.GraalContextCustomizer;
import net.algart.graalvm.GraalPerformer;
import net.algart.graalvm.GraalPerformerContainer;
import net.algart.graalvm.GraalSourceContainer;
import net.algart.graalvm.JSType;
import org.graalvm.polyglot.Value;

public class GraalPerformerContainerTest {
    static GraalPerformerContainerTest test = new GraalPerformerContainerTest();
    GraalPerformerContainer performerContainer = GraalAPI.JS.initializeJS((GraalPerformerContainer.Shared)GraalPerformerContainer.getSharedPure().setCustomizer((GraalContextCustomizer)GraalSafety.SAFE).setActionOnChangeContextId(GraalPerformerContainer.ActionOnChangeContextId.NONE));

    private static void gc() throws InterruptedException {
        System.out.println("gc");
        test = new GraalPerformerContainerTest();
        System.gc();
        Thread.sleep(200L);
        System.gc();
    }

    private void test(String id, boolean doClose) {
        System.out.println("Using " + String.valueOf(this.performerContainer));
        String script = !this.performerContainer.getCustomizer().isJavaAccessSupported() ? "const a = 5; let b = 5; a+b" : "var a = 5; var b = 5; var StringClass = Java.type('java.lang.String');\nvar s = new StringClass(\"asd\");\nprint('SNumbers: ' + SNumbersClass.zeros('int',5,2));\n" + (this.performerContainer.getCustomizer().isAllAccess() ? "java.lang.System.out.println('Java printing: ' + s);\n" : "") + "print('JS printing: ' + s);\ns.length + a+b";
        GraalPerformer performer = this.performerContainer.performer((Object)id);
        GraalSourceContainer sourceContainer = GraalSourceContainer.newLiteralContainer().setJS(JSType.COMMON, (CharSequence)script, "test");
        Value emptyObjectFunction = GraalAPI.JS.storedCreateEmptyObjectFunction((GraalPerformer)performer);
        System.out.println("Empty object function: \"" + String.valueOf(emptyObjectFunction) + "\"; its result: " + String.valueOf(emptyObjectFunction.execute(new Object[0])));
        Value v = performer.perform(sourceContainer);
        System.out.println(v);
        System.out.println("Number of shared contexts inside: " + GraalPerformerContainer.numberOfSharedPerformers());
        if (doClose) {
            this.performerContainer.freeResources(true);
            System.out.println("Number of shared contexts (closed): " + GraalPerformerContainer.numberOfSharedPerformers());
            System.out.println("Probably closed performer: " + String.valueOf(performer));
        }
    }

    public static void main(String[] args) throws ScriptException, InterruptedException {
        test.test("some-id", false);
        GraalPerformerContainerTest.gc();
        System.out.println("Number of shared contexts (outside) " + GraalPerformerContainer.numberOfSharedPerformers());
        System.out.println();
        GraalPerformerContainerTest.gc();
        GraalPerformerContainerTest.gc();
        test.test("some-id", false);
        System.out.println("Number of shared contexts (outside) " + GraalPerformerContainer.numberOfSharedPerformers());
        System.out.println();
        test.test("some-id2", false);
        GraalPerformerContainerTest.gc();
        System.out.println("Number of shared contexts (outside) " + GraalPerformerContainer.numberOfSharedPerformers());
        System.out.println();
        test.test("some-id3", true);
        GraalPerformerContainerTest.gc();
        GraalPerformerContainerTest.gc();
        GraalPerformerContainerTest.gc();
        System.out.println("Number of shared contexts (outside): " + GraalPerformerContainer.numberOfSharedPerformers());
    }
}

