/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.logic;

import java.util.function.BiFunction;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.logic.ConditionStyle;

public class ConditionStyleTest {
    private static void test(BiFunction<String, Boolean, Boolean> converter, String s, boolean expected) {
        if (SScalar.toJavaLikeBoolean((String)s) && !SScalar.toCLikeBoolean((String)s)) {
            throw new AssertionError((Object)("If Java-like is true, C-Like also must be true! " + s));
        }
        if (converter.apply(s, false) != expected) {
            throw new AssertionError((Object)s);
        }
        if (converter.apply(s, true) != expected) {
            throw new AssertionError((Object)s);
        }
        if (converter.apply(null, false).booleanValue()) {
            throw new AssertionError((Object)s);
        }
        if (!converter.apply(null, true).booleanValue()) {
            throw new AssertionError((Object)s);
        }
    }

    public static void main(String[] args) {
        ConditionStyleTest.test(SScalar::toCommonBoolean, "1", true);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "0", false);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "0.00", false);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "0.01", true);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "true", true);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "False", false);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "false", false);
        ConditionStyleTest.test(SScalar::toCommonBoolean, "", false);
        ConditionStyleTest.test(SScalar::toCommonBoolean, " ", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "1", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "0", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "0.00", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "0.01", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "true", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "false", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), "", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.C_LIKE).toBoolean(arg_0, arg_1), " ", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "1", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "0", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "true", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "TRUE", true);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "false", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), " ", false);
        ConditionStyleTest.test((arg_0, arg_1) -> ((ConditionStyle)ConditionStyle.JAVA_LIKE).toBoolean(arg_0, arg_1), "", false);
        System.out.println("O'k");
    }
}

