/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import net.algart.executors.api.Executor;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;

public final class ExampleLoadingStage
extends Executor {
    private static final ExecutorLoader MY_LOADER = new DefaultExecutorLoader("test loader");

    public ExampleLoadingStage() {
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public void process() {
        String id = "7ec64582-de9e-4607-85ad-adfa97a3b0e5";
        ExecutorSpecification executorSpecification = ExecutorSpecification.of((Executor)new TestExecutor(), (String)"7ec64582-de9e-4607-85ad-adfa97a3b0e5");
        String sessionId = this.getSessionId();
        MY_LOADER.setSpecification(sessionId, executorSpecification);
        this.getScalar(DEFAULT_OUTPUT_PORT).setTo(executorSpecification.jsonString());
        System.out.println("Loading-stage test for session " + sessionId);
        System.out.println("Current folder: " + String.valueOf(this.getCurrentDirectory()));
        System.out.println(ExampleLoadingStage.globalLoaders().allSerializedSpecifications(sessionId, true));
    }

    static {
        ExampleLoadingStage.globalLoaders().register(MY_LOADER);
    }

    public static class TestExecutor
    extends Executor {
        private int parameter1;
        private String parameter2;
        private Mode mode;

        public TestExecutor() {
            this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        }

        public int getParameter1() {
            return this.parameter1;
        }

        public TestExecutor setParameter1(int parameter1) {
            this.parameter1 = parameter1;
            return this;
        }

        public String getParameter2() {
            return this.parameter2;
        }

        public TestExecutor setParameter2(String parameter2) {
            this.parameter2 = parameter2;
            return this;
        }

        public Mode getMode() {
            return this.mode;
        }

        public TestExecutor setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public void process() {
            this.getScalar().setTo("Called from " + String.valueOf((Object)this) + "\nexecutorId=" + this.getExecutorId() + "\nsessionId=" + this.getSessionId());
        }

        public String toString() {
            return "TestExecutor{parameter1=" + this.parameter1 + ", parameter2='" + this.parameter2 + "', mode=" + String.valueOf((Object)this.mode) + "}";
        }

        public static enum Mode {
            MODE_1,
            MODE_2;

        }
    }
}

