/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.demo;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import net.algart.executors.api.Executor;
import net.algart.executors.api.jep.JepAPI;
import net.algart.jep.JepPerformer;
import net.algart.jep.JepPerformerContainer;
import net.algart.jep.additions.JepType;

public class ExampleJep
extends Executor {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private boolean subInterpreter = true;
    private final JepPerformerContainer normal = JepAPI.newContainer((JepType)JepType.NORMAL);
    private final JepPerformerContainer sub = JepAPI.newContainer((JepType)JepType.SUB_INTERPRETER);
    private final int instanceId = COUNTER.incrementAndGet();

    public boolean isSubInterpreter() {
        return this.subInterpreter;
    }

    public ExampleJep setSubInterpreter(boolean subInterpreter) {
        this.subInterpreter = subInterpreter;
        return this;
    }

    public ExampleJep() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public void process() {
        this.getScalar().setTo(this.testJep(this.getInputScalar(true).getValue()));
    }

    public Object testJep(String value) {
        long t1 = System.nanoTime();
        JepPerformer performer = (this.subInterpreter ? this.sub : this.normal).performer();
        long t2 = System.nanoTime();
        String script = "from java.lang import System\n" + (!this.subInterpreter ? "import numpy\n" : "") + "import sys\n\ndef test():\n    System.out.println('Hello from JEP!' + str(sys.path))\n    return 'Hello from JEP, executor #" + this.instanceId + "'\n";
        performer.perform(script);
        long t3 = System.nanoTime();
        Object result = performer.invokeFunction("test", new Object[0]);
        ExampleJep.logInfo((String)String.format(Locale.US, "Executing Python example: %.6f ms getting/creating context + %.6f ms processing", (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6));
        return value == null ? result : value;
    }

    public void close() {
        super.close();
        this.normal.close();
        this.sub.close();
    }

    public static void main(String[] args) {
        System.out.println(new ExampleJep().setSubInterpreter(false).testJep("shared"));
        System.out.println(new ExampleJep().setSubInterpreter(true).testJep("sub-interpreter"));
    }
}

