/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.time.Duration;
import java.time.Instant;
import java.util.Locale;
import net.algart.executors.api.Executor;

public class TimingSpeed {
    static final int N = 10000000;

    private static void test() {
        long t1 = System.nanoTime();
        long sum = 0L;
        for (int k = 0; k < 10000000; ++k) {
            sum += (long)k;
        }
        long t2 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += System.nanoTime();
        }
        long t3 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += System.currentTimeMillis();
        }
        long t4 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += Executor.debugTime() + (long)k;
        }
        long t5 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += Executor.allocatedMemory() + (long)k;
        }
        long t6 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += Executor.fineAllocatedMemory() + (long)k;
        }
        long t7 = System.nanoTime();
        Instant firstInstant = Instant.now();
        for (int k = 0; k < 10000000; ++k) {
            firstInstant = Instant.now();
        }
        long t8 = System.nanoTime();
        for (int k = 0; k < 10000000; ++k) {
            sum += (long)Duration.between(firstInstant, Instant.now()).getNano();
        }
        long t9 = System.nanoTime();
        System.out.printf(Locale.US, "Empty loop: %.3f ms, %.2f ns/element (result = %d)%n", (double)(t2 - t1) * 1.0E-6, (double)(t2 - t1) / 1.0E7, sum);
        System.out.printf(Locale.US, "System.nanoTime(): %.3f ms, %.2f ns/call%n", (double)(t3 - t2) * 1.0E-6, (double)(t3 - t2) / 1.0E7);
        System.out.printf(Locale.US, "System.currentTimeMillis(): %.3f ms, %.2f ns/call%n", (double)(t4 - t3) * 1.0E-6, (double)(t4 - t3) / 1.0E7);
        System.out.printf(Locale.US, "Executor.debugTime(): %.3f ms, %.2f ns/call%n", (double)(t5 - t4) * 1.0E-6, (double)(t5 - t4) / 1.0E7);
        System.out.printf(Locale.US, "Executor.allocatedMemory(): %.3f ms, %.2f ns/call%n", (double)(t6 - t5) * 1.0E-6, (double)(t6 - t5) / 1.0E7);
        System.out.printf(Locale.US, "Executor.fineAllocatedMemory(): %.3f ms, %.2f ns/call%n", (double)(t7 - t6) * 1.0E-6, (double)(t7 - t6) / 1.0E7);
        System.out.printf(Locale.US, "Instant.now(): %.3f ms, %.2f ns/call%n", (double)(t8 - t7) * 1.0E-6, (double)(t8 - t7) / 1.0E7);
        System.out.printf(Locale.US, "Duration.between(..., Instant.now()): %.3f ms, %.2f ns/call%n", (double)(t9 - t8) * 1.0E-6, (double)(t9 - t8) / 1.0E7);
        System.out.println();
    }

    public static void main(String[] args) {
        for (int iteration = 0; iteration < 15; ++iteration) {
            System.out.printf("%nTest %d:%n", iteration);
            TimingSpeed.test();
        }
    }
}

