/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import net.algart.executors.api.data.SMat;
import net.algart.executors.modules.core.demo.ExampleMultiMatrixGradients;
import net.algart.io.MatrixIO;
import net.algart.multimatrix.MultiMatrix;

public class SimpleConvertibleTest {
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.printf("Usage: %s some_test.bmp%n", SimpleConvertibleTest.class.getName());
            return;
        }
        Path resultFile = Path.of(args[0], new String[0]);
        ExampleMultiMatrixGradients e = new ExampleMultiMatrixGradients();
        e.setElementType(Byte.TYPE);
        MultiMatrix mm = e.create(1000L, 1000L, 1);
        SMat m = SMat.of((MultiMatrix)mm, (SMat.ChannelOrder)SMat.ChannelOrder.STANDARD);
        ByteBuffer byteBuffer = m.getByteBuffer();
        byte[] array = m.getPointer().toByteArray(m);
        System.out.printf("Multi-matrix: %s%n", mm);
        System.out.printf("SMat: %s%n", m);
        System.out.printf("byteBufeer: %s%n", byteBuffer);
        System.out.printf("array: byte[%d]%n", array.length);
        SMat copy = new SMat().setAll(m.getDimensions(), m.getDepth(), m.getNumberOfChannels(), byteBuffer, false);
        BufferedImage bi = copy.toBufferedImage();
        assert (bi != null);
        System.out.printf("BufferedImage: %s%n", bi);
        MatrixIO.writeBufferedImage((Path)resultFile, (BufferedImage)bi);
        System.out.printf("Written to %s%n", resultFile);
    }
}

