/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.system.ControlSpecification;
import net.algart.executors.api.system.ExecutorLoaderSet;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.executors.api.system.ExecutorSpecificationFactory;
import net.algart.executors.api.system.SettingsTree;
import net.algart.executors.api.system.SmartSearchSettings;

public class SettingsTreeTest {
    public static final String MY_SESSION_ID = "~~DUMMY_SESSION";
    public static final String DEMO_CHAIN_SETTINGS_ID = "0526290c-5160-4509-82d7-9687e594ab53";

    public static void main(String[] args) throws IOException {
        System.setProperty("net.algart.executors.root", "build");
        ExecutionBlock.initializeExecutionSystem();
        ExecutorLoaderSet global = ExecutionBlock.globalLoaders();
        Set allIds = global.allExecutorIds(MY_SESSION_ID, true);
        System.out.printf("%nFound %d standard executors%n%n", allIds.size());
        SettingsTree treeQuick = null;
        SettingsTree treeSmart = null;
        String sQuick = null;
        String sSmart = null;
        for (int test = 1; test <= 16; ++test) {
            SmartSearchSettings smartSearch = SmartSearchSettings.newInstance((ExecutorLoaderSet)global, (String)MY_SESSION_ID);
            ExecutorSpecificationFactory factory = smartSearch.factory();
            long t1 = System.nanoTime();
            ExecutorSpecification specification = factory.getSpecification(DEMO_CHAIN_SETTINGS_ID);
            long t2 = System.nanoTime();
            treeQuick = SettingsTree.of((ExecutorSpecificationFactory)factory, (ExecutorSpecification)specification);
            long t3 = System.nanoTime();
            sQuick = treeQuick.specificationJsonString(ExecutorSpecification.JsonMode.MEDIUM);
            long t4 = System.nanoTime();
            treeSmart = SettingsTree.of((SmartSearchSettings)smartSearch, (ExecutorSpecification)specification);
            long t5 = System.nanoTime();
            sSmart = treeSmart.specificationJsonString(ExecutorSpecification.JsonMode.MEDIUM);
            long t6 = System.nanoTime();
            System.out.printf("Test #%d: get specification %.3f ms, quick tree %.3f + %.3f ms JSON string, smart tree %.3f ms + %.3f ms JSON string%n", test, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6);
        }
        System.out.println();
        System.out.printf("**** %s **** %n", treeQuick);
        System.out.println(sQuick);
        System.out.println();
        System.out.printf("**** %s ****%n", treeSmart);
        System.out.println(sSmart);
        System.out.printf("**** Smart default values: **** %n%s%n%n", treeSmart.defaultSettingsJsonString());
        System.out.println("**** Trees: ****");
        for (SettingsTree.Path path : treeSmart.treePaths()) {
            System.out.printf("%s:%n    node: %s%n    root: %s%n", path, path.reqTree(), path.rootTree());
            if (path.parent() != null && !path.startsWith(path.parent())) {
                throw new AssertionError();
            }
        }
        System.out.println();
        System.out.println("**** Controls: ****");
        for (SettingsTree.Path path : treeSmart.controlPaths()) {
            System.out.printf("%s:%n    %s%n", path, path.reqControl().toJson());
            SettingsTree.Path parent = path.parent();
            if (parent == null) {
                throw new AssertionError();
            }
            if (!path.startsWith(parent)) {
                throw new AssertionError();
            }
            if (!path.startsWith(path)) {
                throw new AssertionError();
            }
            if (parent.startsWith(path)) {
                throw new AssertionError();
            }
        }
        System.out.println();
        System.out.println("**** Testing some paths ****");
        SettingsTree.Path tree1Path = treeSmart.newPath(new String[]{"Simple_settings_1"});
        if (!tree1Path.lastName().equals("Simple_settings_1")) {
            throw new AssertionError();
        }
        SettingsTree.Path strPath = treeSmart.newPath(new String[]{"Simple_settings_1", "str"});
        if (!strPath.lastName().equals("str")) {
            throw new AssertionError();
        }
        SettingsTree.Path rootPath = strPath.root();
        if (!rootPath.equals((Object)treeSmart.newPath(new String[0]))) {
            throw new AssertionError();
        }
        if (rootPath.equals((Object)treeQuick.newPath(new String[0]))) {
            throw new AssertionError((Object)"Different trees!");
        }
        if (!tree1Path.startsWith(rootPath)) {
            throw new AssertionError();
        }
        if (tree1Path.startsWith(strPath)) {
            throw new AssertionError();
        }
        if (!strPath.startsWith(tree1Path)) {
            throw new AssertionError();
        }
        if (!strPath.startsWith(strPath)) {
            throw new AssertionError();
        }
        SettingsTree tree1 = tree1Path.reqTree();
        System.out.printf("Path %s: %s%n", tree1Path, tree1);
        ControlSpecification tree1ControlStr = strPath.reqControl();
        System.out.printf("Path %s: %s%n", strPath, tree1ControlStr);
        System.out.printf("Root path %s: %s%n", rootPath, rootPath.reqTree());
        ControlSpecification controlStr = tree1.newPath(new String[]{"str"}).reqControl();
        System.out.printf("%nControl \"str\" from the sub-tree: %s%n", controlStr);
        System.out.printf("%nReference equality to the previous control: %s%n", controlStr == tree1ControlStr);
    }

    private static String listToString(List<?> paths) {
        return paths.stream().map(Object::toString).collect(Collectors.joining("\n"));
    }
}

