/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.tests;

import net.algart.executors.api.data.SNumbers;
import net.algart.math.IRange;
import net.algart.math.IRectangularArea;
import net.algart.math.Range;
import net.algart.math.RectangularArea;

public class SNumbersRectangularAreasTest {
    private static void test(IRectangularArea area) {
        SNumbers numbers = new SNumbers().setTo(area);
        IRectangularArea copy = numbers.toIRectangularArea();
        if (!area.equals((Object)copy)) {
            throw new AssertionError(area);
        }
        System.out.println("Tested " + String.valueOf(area) + " <-> " + String.valueOf(numbers));
    }

    private static void test(RectangularArea area) {
        SNumbers numbers = new SNumbers().setTo(area);
        RectangularArea copy = numbers.toRectangularArea();
        if (!area.equals((Object)copy)) {
            throw new AssertionError(area);
        }
        System.out.println("Tested " + String.valueOf(area) + " <-> " + String.valueOf(numbers));
    }

    public static void main(String[] args) {
        SNumbersRectangularAreasTest.test(IRectangularArea.of((long)1L, (long)2L, (long)10L, (long)11L));
        SNumbersRectangularAreasTest.test(IRectangularArea.of((IRange[])new IRange[]{IRange.of((long)1L, (long)10L)}));
        SNumbersRectangularAreasTest.test(IRectangularArea.of((long)123L, (long)5L, (long)523L, (long)54125L, (long)73L, (long)1000L));
        SNumbersRectangularAreasTest.test(RectangularArea.of((double)0.6, (double)2.0, (double)10.0, (double)11.3));
        SNumbersRectangularAreasTest.test(RectangularArea.of((Range[])new Range[]{Range.of((double)1.0, (double)1.1)}));
        SNumbersRectangularAreasTest.test(RectangularArea.of((double)1.23, (double)5.0, (double)52.3, (double)541.25, (double)7.3, (double)100.6));
    }
}

