/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import javax.imageio.ImageIO;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.chains.core.ChainExecutor;
import net.algart.executors.api.chains.core.UseChain;
import net.algart.executors.api.data.Port;
import net.algart.executors.api.data.SMat;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.DefaultExecutorLoader;
import net.algart.executors.api.system.ExecutorSpecification;
import net.algart.io.MatrixIO;

public class CallSimpleChainForImage {
    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.out.printf("Usage: %s some_chain.chain input_image output_image [a b]%nsome_chain.chain should be some chain, which process single image and have 2 parameters named a and b;%ninput_image should be some image file, for example, JPEG or BMP;%noutput_image should be result image file;%na and b should be parameters of the chain.", CallSimpleChainForImage.class.getName());
            return;
        }
        Path chainPath = Paths.get(args[0], new String[0]);
        Path inputImagePath = Paths.get(args[1], new String[0]);
        Path outputImagePath = Paths.get(args[2], new String[0]);
        String parameterA = args.length > 3 ? args[3] : null;
        String parameterB = args.length > 4 ? args[4] : null;
        System.out.printf("Reading %s...%n", inputImagePath.toAbsolutePath());
        SMat inputMat = SMat.of((BufferedImage)ImageIO.read(inputImagePath.toFile()));
        ExecutionBlock.initializeExecutionSystem();
        System.out.printf("Loading %s...%n", chainPath.toAbsolutePath());
        try (ChainExecutor executor = UseChain.newSharedExecutor((Path)chainPath, (CreateMode)CreateMode.REQUEST_DEFAULT);){
            CallSimpleChainForImage.printChainExecutors();
            CallSimpleChainForImage.printExecutorInterface((ExecutionBlock)executor);
            executor.putMat(inputMat);
            if (parameterA != null) {
                executor.setStringParameter("a", parameterA);
            }
            if (parameterB != null) {
                executor.setStringParameter("b", parameterB);
            }
            executor.execute();
            BufferedImage result = executor.getMat().toBufferedImage();
            if (result == null) {
                throw new IllegalArgumentException("Chain " + String.valueOf(chainPath) + " did not create output image");
            }
            MatrixIO.writeBufferedImage((Path)outputImagePath, (BufferedImage)result);
            System.out.printf("%s%nDone: result saved in %s%n", executor, outputImagePath);
        }
    }

    static void printChainExecutors() {
        DefaultExecutorLoader loader = UseChain.chainLoader();
        System.out.printf("All registered chain IDs: %s%n", loader.allExecutorIds("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f"));
        System.out.println("All registered chains:");
        for (String serialized : loader.allSerializedSpecifications("$~~GLOBAL-SESSION~~_699d349b-3312-4d5d-8fc4-0444dd2b387f").values()) {
            ExecutorSpecification specification = ExecutorSpecification.of((String)serialized);
            System.out.printf("    %s%n", specification.getName());
        }
    }

    static void printExecutorInterface(ExecutionBlock executor) {
        System.out.println();
        System.out.println("Executor settings:");
        System.out.printf("    ID = %s%n", executor.getExecutorId());
        System.out.printf("    session ID = %s%n", executor.getSessionId());
        System.out.printf("    current directory = %s%n", executor.getCurrentDirectory());
        System.out.printf("    context path = %s%n", executor.getContextPath());
        System.out.println("All parameters");
        for (Map.Entry e : executor.parameters().entrySet()) {
            System.out.printf("    %s = %s%n", e.getKey(), e.getValue());
        }
        System.out.println("All input ports:");
        for (Port p : executor.inputPorts()) {
            System.out.printf("    %s%n", p);
        }
        System.out.println("All output ports:");
        for (Port p : executor.outputPorts()) {
            System.out.printf("    %s%n", p);
        }
        System.out.println();
    }
}

