/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.api.demo;

import java.io.IOException;
import net.algart.executors.api.ExecutionBlock;
import net.algart.executors.api.demo.CallSimpleChainForImage;
import net.algart.executors.api.system.CreateMode;
import net.algart.executors.api.system.ExecutorFactory;

public class CallExecutorRecursiveFactorial {
    public static final String MY_SESSION_ID = "~~DUMMY_SESSION";
    public static final String RECURSIVE_FACTORIAL_ID = "8585f3b5-decf-45e5-be50-e91b7a1a693c";

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        if (args.length < 1) {
            System.out.printf("Usage: %s number_to_calculate_factorial%n", CallExecutorRecursiveFactorial.class.getName());
            return;
        }
        int value = Integer.parseInt(args[0]);
        ExecutionBlock.initializeExecutionSystem();
        ExecutorFactory factory = ExecutorFactory.newFactory((String)MY_SESSION_ID);
        try (ExecutionBlock executor = factory.newExecutor(RECURSIVE_FACTORIAL_ID, CreateMode.REQUEST_ALL);){
            CallSimpleChainForImage.printExecutorInterface(executor);
            executor.setIntParameter("n", value);
            executor.execute();
            double result = executor.getScalar().toDouble();
            System.out.println("Factorial of " + value + " is " + result);
        }
    }
}

