/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.objects;

import net.algart.arrays.Arrays;
import net.algart.math.geometry.StraightLine3D;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraStraightIntersectionsFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraVoxelBuilder;

public final class SpherePolyhedraSimpleVoxelBuilder
extends SpherePolyhedraVoxelBuilder {
    SpherePolyhedraSimpleVoxelBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, int dimX, int dimY, int dimZ) {
        super(spherePolyhedra, elementType, dimX, dimY, dimZ, SpherePolyhedraVoxelBuilder.BuildingDistancesMode.NONE);
    }

    @Override
    void preprocess() {
    }

    @Override
    void processStraight(int straightIndex, int threadIndex) {
        SpherePolyhedraStraightIntersectionsFinder intersectionsFinder = this.threadIntersectionsFinders[threadIndex];
        long startPosition = (long)straightIndex * (long)this.dimX;
        int voxelZ = straightIndex / this.dimY;
        int voxelY = straightIndex % this.dimY;
        StraightLine3D straight = this.getSraightAlongVoxelX(0, voxelY, voxelZ);
        intersectionsFinder.findAllIntersections(straight, index -> this.spherePolyhedraVoxelValues[index] >= 0);
        intersectionsFinder.sortByLabel(index -> this.spherePolyhedraVoxelValues[index]);
        int n = intersectionsFinder.numberOfPoints();
        assert (n % 2 == 0) : "Number of intersections must be even: " + n;
        for (int k = 0; k < n; k += 2) {
            int voxelX1 = Arrays.round32((double)(intersectionsFinder.t[k] * this.scaleX));
            int voxelX2 = Arrays.round32((double)(intersectionsFinder.t[k + 1] * this.scaleX));
            int spherePolyhedronIndex = intersectionsFinder.spherePolyhedronIndexes[k];
            assert (spherePolyhedronIndex == intersectionsFinder.spherePolyhedronIndexes[k + 1]) : "Indexes are not correctly sorted";
            assert (voxelX1 <= voxelX2) : "Intersections are not correctly sorted";
            int filler = this.spherePolyhedraVoxelValues[spherePolyhedronIndex];
            this.fill(startPosition, voxelX1, voxelX2, filler);
        }
    }
}

