/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds.restrictions;

import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class NeighbourKindProhibition
implements PackingRestriction {
    private long prohibitedNeighbourKindId = 0L;
    private int maximalNumberOfProhibitedNeighbours = 0;

    public long getProhibitedNeighbourKindId() {
        return this.prohibitedNeighbourKindId;
    }

    public NeighbourKindProhibition setProhibitedNeighbourKindId(long prohibitedNeighbourKindId) {
        this.prohibitedNeighbourKindId = prohibitedNeighbourKindId;
        return this;
    }

    public int getMaximalNumberOfProhibitedNeighbours() {
        return this.maximalNumberOfProhibitedNeighbours;
    }

    public NeighbourKindProhibition setMaximalNumberOfProhibitedNeighbours(int maximalNumberOfProhibitedNeighbours) {
        if (maximalNumberOfProhibitedNeighbours < 0 || maximalNumberOfProhibitedNeighbours > 3) {
            throw new IllegalArgumentException("Illegal maximal number of prohibited neighbours " + maximalNumberOfProhibitedNeighbours + " (must be in 0..3 range)");
        }
        this.maximalNumberOfProhibitedNeighbours = maximalNumberOfProhibitedNeighbours;
        return this;
    }

    @Override
    public boolean allowFirstNeighbour(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex, long neighbourKindId) {
        return this.maximalNumberOfProhibitedNeighbours <= 0 || neighbourKindId != this.prohibitedNeighbourKindId;
    }

    @Override
    public boolean allowAllNeighbours(int indexOfNewlyPackedObject, SpherePolyhedrion newlyPackedObject, int neighbourIndex1, long neighbourKindId1, int neighbourIndex2, long neighbourKindId2, int neighbourIndex3, long neighbourKindId3) {
        if (this.maximalNumberOfProhibitedNeighbours >= 3) {
            return true;
        }
        return (neighbourKindId1 == this.prohibitedNeighbourKindId ? 1 : 0) + (neighbourKindId2 == this.prohibitedNeighbourKindId ? 1 : 0) + (neighbourKindId3 == this.prohibitedNeighbourKindId ? 1 : 0) <= this.maximalNumberOfProhibitedNeighbours;
    }

    public String toString() {
        return "prohibit >" + this.maximalNumberOfProhibitedNeighbours + " neighbours " + SpherePolyhedronKind.idToFriendlyString(this.prohibitedNeighbourKindId);
    }
}

