/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.kinds;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.kinds.BarKind;
import net.algart.model3d.spherepolyhedra.kinds.CubeKind;
import net.algart.model3d.spherepolyhedra.kinds.KindWithRandomDistribution;
import net.algart.model3d.spherepolyhedra.kinds.SphereBarKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereCrossKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereCubeKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereCylinderKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereOneSizeParallelepipedKind;
import net.algart.model3d.spherepolyhedra.kinds.SphereOneSizeParallelogramKind;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestriction;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.PackingRestrictionFactory;
import net.algart.model3d.spherepolyhedra.kinds.restrictions.SpherePolyhedraNeighbourhoodPackingRestrictionSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public abstract class SpherePolyhedronKind
implements PackingRestrictionFactory {
    public static final String CLASS_JSON_PROPERTY = "class";
    public static final String KIND_JSON_PROPERTY = "kind";
    public static final String FRIENDLY_ID_SYSTEM_PREFIX = "$";
    private static final long DEFAULT_ID = 1L;
    private static final int DEFAULT_LABEL = 1;
    private static final Map<String, Class<? extends SpherePolyhedronKind>> KNOWN_KINDS = Collections.synchronizedMap(new LinkedHashMap());
    private long id = 1L;
    private int label = 1;
    private double fraction = 1.0;
    private Color color = Color.WHITE;
    private SpherePolyhedraNeighbourhoodPackingRestrictionSet restrictionSet = new SpherePolyhedraNeighbourhoodPackingRestrictionSet();
    private String kindName = null;
    private boolean kindNameFound = false;

    protected SpherePolyhedronKind() {
    }

    public static <T extends SpherePolyhedronKind> T newInstance(Class<T> kindClass) {
        return SpherePolyhedronKind.newInstance(kindClass, null);
    }

    public static <T extends SpherePolyhedronKind> T newInstance(Class<T> kindParentClass, String subclassName) {
        Objects.requireNonNull(kindParentClass, "Null kind class");
        try {
            if (subclassName == null) {
                return (T)((SpherePolyhedronKind)kindParentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            Class<T> clazz = Class.forName(subclassName).asSubclass(kindParentClass);
            return (T)((SpherePolyhedronKind)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new JsonException("Cannot create sphere-polyhedron kind for class " + subclassName, (Throwable)e);
        }
    }

    public static SpherePolyhedronKind of(JsonObject json) {
        String kindName = json.getString(KIND_JSON_PROPERTY, null);
        Class<SpherePolyhedronKind> kindClass = kindName != null ? KNOWN_KINDS.get(kindName) : SpherePolyhedronKind.class;
        String className = kindName != null ? null : Jsons.reqString((JsonObject)json, (String)CLASS_JSON_PROPERTY);
        SpherePolyhedronKind kind = SpherePolyhedronKind.newInstance(kindClass, className);
        kind.fromJsonImplementation(json);
        return kind;
    }

    public static void registerKind(String simpleName, Class<? extends SpherePolyhedronKind> kindClass) {
        Objects.requireNonNull(simpleName, "Null simple name");
        Objects.requireNonNull(kindClass, "Null kind class");
        KNOWN_KINDS.put(simpleName, kindClass);
    }

    public final long getId() {
        return this.id;
    }

    public final String getFriendlyId() {
        return SpherePolyhedronKind.idToFriendlyString(this.id);
    }

    public final SpherePolyhedronKind setId(long id) {
        if (id <= 0L) {
            throw new IllegalArgumentException("Zero or negative id = " + id);
        }
        this.id = id;
        return this;
    }

    public int getLabel() {
        return this.label;
    }

    public SpherePolyhedronKind setLabel(int label) {
        this.label = label;
        return this;
    }

    public final double getFraction() {
        return this.fraction;
    }

    public final SpherePolyhedronKind setFraction(double fraction) {
        if (fraction < 0.0) {
            throw new IllegalArgumentException("Negative fraction");
        }
        this.fraction = fraction;
        return this;
    }

    public final Color getColor() {
        return this.color;
    }

    public final SpherePolyhedronKind setColor(Color color) {
        this.color = Objects.requireNonNull(color, "Null color");
        return this;
    }

    public final SpherePolyhedraNeighbourhoodPackingRestrictionSet getRestrictionSet() {
        return this.restrictionSet;
    }

    public final SpherePolyhedronKind setRestrictionSet(SpherePolyhedraNeighbourhoodPackingRestrictionSet restrictionSet) {
        this.restrictionSet = Objects.requireNonNull(restrictionSet, "Null restrictions set");
        return this;
    }

    public abstract SpherePolyhedrion newSpherePolyhedrion(Random var1);

    public double newSpherePolyhedrionSummaryVolume(Random random) {
        return this.newSpherePolyhedrion(random).summaryVolume();
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        this.toJsonImplementation(builder);
        return builder.build();
    }

    public void setToJson(JsonObject json) {
        Objects.requireNonNull(json, "Null json");
        this.fromJsonImplementation(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String kindName() {
        Map<String, Class<? extends SpherePolyhedronKind>> map = KNOWN_KINDS;
        synchronized (map) {
            if (this.kindNameFound) {
                return this.kindName;
            }
            this.kindNameFound = true;
            for (Map.Entry<String, Class<? extends SpherePolyhedronKind>> entry : KNOWN_KINDS.entrySet()) {
                if (!this.getClass().equals(entry.getValue())) continue;
                this.kindName = entry.getKey();
                return this.kindName;
            }
            this.kindName = null;
            return null;
        }
    }

    @Override
    public PackingRestriction getRecommendedPackingRestriction(SpherePolyhedrion objectToPack) {
        return this.restrictionSet;
    }

    public String toString() {
        return "kind " + this.getClass().getSimpleName() + ": id " + this.getFriendlyId() + ", color " + Jsons.toString((Color)this.color) + ", fraction " + this.fraction + (String)(this.restrictionSet.numberOfRestrictions() == 0 ? "" : ", " + String.valueOf(this.restrictionSet));
    }

    protected void toJsonImplementation(JsonObjectBuilder builder) {
        String kindName = this.kindName();
        if (kindName != null) {
            builder.add(KIND_JSON_PROPERTY, kindName);
        }
        builder.add(CLASS_JSON_PROPERTY, this.getClass().getName());
        builder.add("id", this.getFriendlyId());
        builder.add("label", this.getLabel());
        builder.add("numeric_id", this.id);
        builder.add("color", Jsons.toString((Color)this.color));
        builder.add("fraction", this.fraction);
        if (this.restrictionSet.numberOfRestrictions() > 0) {
            builder.add("restrictions", (JsonValue)this.restrictionSet.toJsonArray());
        }
    }

    protected void fromJsonImplementation(JsonObject json) {
        this.setId(SpherePolyhedronKind.getId(json));
        this.setLabel(json.getInt("label", 1));
        this.setFraction(Jsons.getDouble((JsonObject)json, (String)"fraction", (double)1.0));
        this.setColor(Jsons.toColor((String)json.getString("color", "#FFFFFF")));
        this.setRestrictionSet(new SpherePolyhedraNeighbourhoodPackingRestrictionSet().setToJson(Jsons.getJsonObjectsOrEmptyList((JsonObject)json, (String)"restrictions")));
    }

    public static String idToFriendlyString(long id) {
        boolean system = id < 0L;
        String prefix = "";
        if (system) {
            id = -id;
            prefix = FRIENDLY_ID_SYSTEM_PREFIX;
        }
        StringBuilder sb = new StringBuilder();
        for (int k = 7; k >= 0; --k) {
            boolean allowedZeroChar;
            char c = (char)(id >>> k * 8 & 0xFFL);
            boolean bl = allowedZeroChar = c == '\u0000' && k > 0;
            if (!allowedZeroChar && !SpherePolyhedronKind.isValidIdChar(c)) {
                return String.format("%s0x%X", prefix, id);
            }
            if (c == '\u0000') {
                c = ' ';
            }
            sb.append(c);
        }
        String result = sb.toString().trim();
        assert (result.length() > 0) : "Zero low byte of " + id + " was not detected above!";
        assert (result.length() <= 8) : "Too long result: \"" + result + "\" (" + result.length() + " characters)";
        if (result.charAt(0) == '0') {
            return String.format("%s0x%X", prefix, id);
        }
        return prefix + result;
    }

    public static long friendlyStringToId(String friendlyId) {
        int length;
        Objects.requireNonNull(friendlyId, "Null friendly ID");
        friendlyId = friendlyId.trim();
        boolean system = friendlyId.startsWith(FRIENDLY_ID_SYSTEM_PREFIX);
        if (system) {
            friendlyId = friendlyId.substring(FRIENDLY_ID_SYSTEM_PREFIX.length());
        }
        if ((length = friendlyId.length()) == 0) {
            throw new IllegalArgumentException("Empty string is not an id");
        }
        if (friendlyId.charAt(0) == '0') {
            if (friendlyId.equalsIgnoreCase("0x8000000000000000")) {
                return Long.MIN_VALUE;
            }
            return system ? -Long.decode(friendlyId).longValue() : Long.decode(friendlyId);
        }
        if (length > 8) {
            throw new IllegalArgumentException("String \"" + friendlyId + "\" is longer than 8 characters; cannot be an id");
        }
        long id = 0L;
        for (int k = 0; k < length; ++k) {
            char c = friendlyId.charAt(k);
            if (c == ' ') {
                c = '\u0000';
            } else if (!SpherePolyhedronKind.isValidIdChar(c)) {
                throw new IllegalArgumentException("Illegal characters for id (" + (String)(c > ' ' && c < '\u007f' ? "'" + c + "', " : "") + "code 0x" + Integer.toHexString(c) + ")");
            }
            id = id << 8 | (long)c;
        }
        return system ? -id : id;
    }

    public static Set<Long> splitKindIds(String kindsList) {
        Objects.requireNonNull(kindsList, "Null string with kinds list");
        kindsList = kindsList.trim();
        HashSet<Long> result = new HashSet<Long>();
        if (!kindsList.isEmpty()) {
            for (String s : kindsList.split("[\\s,]+")) {
                if (s.isEmpty()) continue;
                result.add(s.equals(FRIENDLY_ID_SYSTEM_PREFIX) ? 0L : SpherePolyhedronKind.friendlyStringToId(s));
            }
        }
        return result;
    }

    public static Collection<SpherePolyhedronKind> selectKinds(String kindsList, Collection<SpherePolyhedronKind> kinds) {
        Objects.requireNonNull(kindsList, "Null list of kinds to select");
        Objects.requireNonNull(kinds, "Null kinds");
        kindsList = kindsList.trim();
        if (!kindsList.isEmpty()) {
            HashSet<String> allowed = new HashSet<String>(Arrays.asList(kindsList.split("[\\s,]+")));
            ArrayList<SpherePolyhedronKind> selected = new ArrayList<SpherePolyhedronKind>();
            for (SpherePolyhedronKind kind : kinds) {
                if (!allowed.contains(kind.getFriendlyId())) continue;
                selected.add(kind);
            }
            kinds = selected;
        }
        return kinds;
    }

    static double positive(double value, String valueName) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Zero or negative " + valueName + " = " + value);
        }
        return value;
    }

    static double nonNegative(double value, String valueName) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Negative " + valueName + " = " + value);
        }
        return value;
    }

    private static long getId(JsonObject json) {
        JsonValue idJsonValue = (JsonValue)json.get((Object)"numeric_id");
        if (idJsonValue instanceof JsonNumber) {
            return ((JsonNumber)idJsonValue).longValueExact();
        }
        if (idJsonValue != null) {
            throw new JsonException("Invalid JSON: \"numeric_id\" is not a number <<<" + String.valueOf(json) + ">>>");
        }
        String s = Jsons.reqString((JsonObject)json, (String)"id");
        try {
            long id = SpherePolyhedronKind.friendlyStringToId(s);
            if (id < 0L) {
                throw new JsonException("Invalid JSON: \"id\"=\"" + s + "\" is system and is not allowed here <<<" + String.valueOf(json) + ">>>");
            }
            return id;
        }
        catch (RuntimeException e) {
            throw new JsonException("Invalid JSON: illegal \"id\" value: " + e.getMessage() + " <<<" + String.valueOf(json) + ">>>", (Throwable)e);
        }
    }

    private static boolean isValidIdChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '_' || c == '-' || c == '~' || c == '@';
    }

    static {
        for (StandardClass standardClass : StandardClass.values()) {
            SpherePolyhedronKind.registerKind(standardClass.simpleName, standardClass.kindClass);
        }
    }

    public static enum StandardClass {
        SPHERE("sphere", SphereKind.class),
        SPHERE_CYLINDER("sphere-cylinder", SphereCylinderKind.class),
        SPHERE_ONE_SIZE_PARALLELEPIPED("sphere-one-size-parallelepiped", SphereOneSizeParallelepipedKind.class),
        SPHERE_ONE_SIZE_PARALLELOGRAM("sphere-one-size-parallelogram", SphereOneSizeParallelogramKind.class),
        SPHERE_CUBE("sphere-cube", SphereCubeKind.class),
        CUBE("cube", CubeKind.class),
        SPHERE_BAR("sphere-bar", SphereBarKind.class),
        BAR("bar", BarKind.class),
        SPHERE_CROSS("sphere-cross", SphereCrossKind.class);

        private final String simpleName;
        private final Class<? extends KindWithRandomDistribution> kindClass;

        private StandardClass(String simpleName, Class<? extends KindWithRandomDistribution> kindClass) {
            this.simpleName = simpleName;
            this.kindClass = kindClass;
        }

        public String simpleName() {
            return this.simpleName;
        }

        public Class<? extends SpherePolyhedronKind> kindClass() {
            return this.kindClass;
        }

        public KindWithRandomDistribution newKind() {
            return SpherePolyhedronKind.newInstance(this.kindClass);
        }
    }
}

