/*
 * Decompiled with CFR 0.152.
 */
package net.algart.model3d.spherepolyhedra.geometries;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import net.algart.json.Jsons;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;

public final class PreferredVerticalRayPosition {
    private double i = Double.NaN;
    private double j = Double.NaN;
    private double di = 0.0;
    private double dj = 0.0;

    public boolean hasX() {
        return !Double.isNaN(this.i);
    }

    public boolean hasY() {
        return !Double.isNaN(this.j);
    }

    public double getI() {
        return this.i;
    }

    public void setI(double i) {
        this.i = i;
    }

    public double getJ() {
        return this.j;
    }

    public void setJ(double j) {
        this.j = j;
    }

    public double getDi() {
        return this.di;
    }

    public void setDi(double di) {
        this.di = SpherePolyhedraPackingGeometry.nonNegative(di, "di");
    }

    public double getDj() {
        return this.dj;
    }

    public void setDj(double dj) {
        this.dj = SpherePolyhedraPackingGeometry.nonNegative(dj, "dj");
    }

    public final JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (!Double.isNaN(this.i)) {
            builder.add("i", this.i);
        }
        if (this.di != 0.0) {
            builder.add("di", this.di);
        }
        if (!Double.isNaN(this.j)) {
            builder.add("j", this.j);
        }
        if (this.dj != 0.0) {
            builder.add("dj", this.dj);
        }
        return builder.build();
    }

    public PreferredVerticalRayPosition setToJson(JsonObject json) {
        if (json == null) {
            return this;
        }
        this.setI(Jsons.getDouble((JsonObject)json, (String)"i", (double)Double.NaN));
        this.setJ(Jsons.getDouble((JsonObject)json, (String)"j", (double)Double.NaN));
        this.setDi(Jsons.getDouble((JsonObject)json, (String)"di", (double)0.0));
        this.setDj(Jsons.getDouble((JsonObject)json, (String)"dj", (double)0.0));
        return this;
    }
}

