/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.voxels;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import net.algart.arrays.Array;
import net.algart.arrays.ByteArray;
import net.algart.arrays.Matrix;
import net.algart.arrays.PArray;
import net.algart.arrays.TooLargeArrayException;
import net.algart.arrays.UpdatablePArray;
import net.algart.executors.api.ExecutionVisibleResultsInformation;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraProcessor;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedraVoxelBuilder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronDistanceMetric;
import net.algart.multimatrix.MultiMatrix;

public final class ConvertSpherePolyhedraToVoxels
extends SpherePolyhedraProcessor {
    public static final String OUTPUT_DISTANCES = "distance_map";
    public static final String NONE_DISTANCE_METRIC = "NONE";
    private int dimX = 256;
    private int dimY = 256;
    private int dimZ = 256;
    private boolean percents = false;
    private double voxelOriginX = 50.0;
    private double voxelOriginY = 50.0;
    private double voxelOriginZ = 50.0;
    private double spherePolyhedraOriginX = 0.0;
    private double spherePolyhedraOriginY = 0.0;
    private double spherePolyhedraOriginZ = 0.0;
    private double scaleX = 1.0;
    private Double scaleY = 1.0;
    private Double scaleZ = 1.0;
    private double rotationAroundXInDegree = 0.0;
    private double rotationAroundYInDegree = 0.0;
    private double rotationAroundZInDegree = 0.0;
    private ResultType resultType = ResultType.BINARY;
    private SpherePolyhedronDistanceMetric distanceMetric = null;
    private SpherePolyhedraVoxelBuilder.BuildingDistancesMode distancesMode = SpherePolyhedraVoxelBuilder.BuildingDistancesMode.NONE;
    private double maxDistanceToObjects = Double.POSITIVE_INFINITY;
    private boolean processUnknownAndSystemKinds = false;
    private String onlyKinds = "";

    public ConvertSpherePolyhedraToVoxels() {
        this.setDefaultOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputMat(OUTPUT_DISTANCES);
        this.addOutputScalar("number_of_objects");
    }

    public int getDimX() {
        return this.dimX;
    }

    public ConvertSpherePolyhedraToVoxels setDimX(int dimX) {
        this.dimX = ConvertSpherePolyhedraToVoxels.positive((int)dimX);
        return this;
    }

    public int getDimY() {
        return this.dimY;
    }

    public ConvertSpherePolyhedraToVoxels setDimY(int dimY) {
        this.dimY = ConvertSpherePolyhedraToVoxels.positive((int)dimY);
        return this;
    }

    public int getDimZ() {
        return this.dimZ;
    }

    public ConvertSpherePolyhedraToVoxels setDimZ(int dimZ) {
        this.dimZ = ConvertSpherePolyhedraToVoxels.positive((int)dimZ);
        return this;
    }

    public boolean isPercents() {
        return this.percents;
    }

    public ConvertSpherePolyhedraToVoxels setPercents(boolean percents) {
        this.percents = percents;
        return this;
    }

    public double getVoxelOriginX() {
        return this.voxelOriginX;
    }

    public ConvertSpherePolyhedraToVoxels setVoxelOriginX(double voxelOriginX) {
        this.voxelOriginX = voxelOriginX;
        return this;
    }

    public double getVoxelOriginY() {
        return this.voxelOriginY;
    }

    public ConvertSpherePolyhedraToVoxels setVoxelOriginY(double voxelOriginY) {
        this.voxelOriginY = voxelOriginY;
        return this;
    }

    public double getVoxelOriginZ() {
        return this.voxelOriginZ;
    }

    public ConvertSpherePolyhedraToVoxels setVoxelOriginZ(double voxelOriginZ) {
        this.voxelOriginZ = voxelOriginZ;
        return this;
    }

    public double getSpherePolyhedraOriginX() {
        return this.spherePolyhedraOriginX;
    }

    public ConvertSpherePolyhedraToVoxels setSpherePolyhedraOriginX(double spherePolyhedraOriginX) {
        this.spherePolyhedraOriginX = spherePolyhedraOriginX;
        return this;
    }

    public double getSpherePolyhedraOriginY() {
        return this.spherePolyhedraOriginY;
    }

    public ConvertSpherePolyhedraToVoxels setSpherePolyhedraOriginY(double spherePolyhedraOriginY) {
        this.spherePolyhedraOriginY = spherePolyhedraOriginY;
        return this;
    }

    public double getSpherePolyhedraOriginZ() {
        return this.spherePolyhedraOriginZ;
    }

    public ConvertSpherePolyhedraToVoxels setSpherePolyhedraOriginZ(double spherePolyhedraOriginZ) {
        this.spherePolyhedraOriginZ = spherePolyhedraOriginZ;
        return this;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public ConvertSpherePolyhedraToVoxels setScaleX(double scaleX) {
        this.scaleX = ConvertSpherePolyhedraToVoxels.positive((double)scaleX);
        return this;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public ConvertSpherePolyhedraToVoxels setScaleY(Double scaleY) {
        this.scaleY = scaleY == null ? null : Double.valueOf(ConvertSpherePolyhedraToVoxels.positive((double)scaleY));
        return this;
    }

    public double getScaleZ() {
        return this.scaleZ;
    }

    public ConvertSpherePolyhedraToVoxels setScaleZ(Double scaleZ) {
        this.scaleZ = scaleZ == null ? null : Double.valueOf(ConvertSpherePolyhedraToVoxels.positive((double)scaleZ));
        return this;
    }

    public double getRotationAroundXInDegree() {
        return this.rotationAroundXInDegree;
    }

    public ConvertSpherePolyhedraToVoxels setRotationAroundXInDegree(double rotationAroundXInDegree) {
        this.rotationAroundXInDegree = rotationAroundXInDegree;
        return this;
    }

    public double getRotationAroundYInDegree() {
        return this.rotationAroundYInDegree;
    }

    public ConvertSpherePolyhedraToVoxels setRotationAroundYInDegree(double rotationAroundYInDegree) {
        this.rotationAroundYInDegree = rotationAroundYInDegree;
        return this;
    }

    public double getRotationAroundZInDegree() {
        return this.rotationAroundZInDegree;
    }

    public ConvertSpherePolyhedraToVoxels setRotationAroundZInDegree(double rotationAroundZInDegree) {
        this.rotationAroundZInDegree = rotationAroundZInDegree;
        return this;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public ConvertSpherePolyhedraToVoxels setResultType(ResultType resultType) {
        this.resultType = resultType;
        return this;
    }

    public SpherePolyhedronDistanceMetric getDistanceMetric() {
        return this.distanceMetric;
    }

    public ConvertSpherePolyhedraToVoxels setDistanceMetric(SpherePolyhedronDistanceMetric distanceMetric) {
        this.distanceMetric = distanceMetric;
        return this;
    }

    public ConvertSpherePolyhedraToVoxels setDistanceMetric(String distanceMetric) {
        ConvertSpherePolyhedraToVoxels.nonNull((Object)distanceMetric);
        return this.setDistanceMetric(NONE_DISTANCE_METRIC.equals(distanceMetric) ? null : SpherePolyhedronDistanceMetric.valueOf(distanceMetric));
    }

    public SpherePolyhedraVoxelBuilder.BuildingDistancesMode getDistancesMode() {
        return this.distancesMode;
    }

    public ConvertSpherePolyhedraToVoxels setDistancesMode(SpherePolyhedraVoxelBuilder.BuildingDistancesMode distancesMode) {
        this.distancesMode = Objects.requireNonNull(distancesMode);
        return this;
    }

    public double getMaxDistanceToObjects() {
        return this.maxDistanceToObjects;
    }

    public ConvertSpherePolyhedraToVoxels setMaxDistanceToObjects(double maxDistanceToObjects) {
        this.maxDistanceToObjects = ConvertSpherePolyhedraToVoxels.nonNegative((double)maxDistanceToObjects);
        return this;
    }

    public ConvertSpherePolyhedraToVoxels setMaxDistanceToObjects(String maxDistanceToObjects) {
        return this.setMaxDistanceToObjects(ConvertSpherePolyhedraToVoxels.doubleOrPositiveInfinity((String)maxDistanceToObjects));
    }

    public boolean isProcessUnknownAndSystemKinds() {
        return this.processUnknownAndSystemKinds;
    }

    public ConvertSpherePolyhedraToVoxels setProcessUnknownAndSystemKinds(boolean processUnknownAndSystemKinds) {
        this.processUnknownAndSystemKinds = processUnknownAndSystemKinds;
        return this;
    }

    public String getOnlyKinds() {
        return this.onlyKinds;
    }

    public ConvertSpherePolyhedraToVoxels setOnlyKinds(String onlyKinds) {
        this.onlyKinds = (String)ConvertSpherePolyhedraToVoxels.nonNull((Object)onlyKinds);
        return this;
    }

    public ExecutionVisibleResultsInformation visibleResultsInformation() {
        ExecutionVisibleResultsInformation info = super.visibleResultsInformation();
        info.setModel("voxel");
        return info;
    }

    public void process() {
        SpherePolyhedronKindSet kindSet = this.deserializeKindSetWithoutProbabilities(true);
        SpherePolyhedra spherePolyhedra = ConvertSpherePolyhedraToVoxels.deserializeSpherePolyhedra(this);
        this.setStartProcessingTimeStamp();
        boolean kindsExist = this.kindsExist();
        boolean useOnlyKinds = !this.onlyKinds.trim().isEmpty();
        Set<Long> onlyKindIds = SpherePolyhedronKind.splitKindIds(this.onlyKinds);
        int originX = net.algart.arrays.Arrays.round32((double)(this.percents ? this.voxelOriginX / 100.0 * (double)Math.max(0, this.dimX - 1) : this.voxelOriginX));
        int originY = net.algart.arrays.Arrays.round32((double)(this.percents ? this.voxelOriginY / 100.0 * (double)Math.max(0, this.dimY - 1) : this.voxelOriginY));
        int originZ = net.algart.arrays.Arrays.round32((double)(this.percents ? this.voxelOriginZ / 100.0 * (double)Math.max(0, this.dimZ - 1) : this.voxelOriginZ));
        Orthonormal3DBasis basis = Orthonormal3DBasis.DEFAULT;
        basis = basis.rotateJK(Math.toRadians(this.rotationAroundXInDegree));
        basis = basis.rotateKI(Math.toRadians(this.rotationAroundYInDegree));
        basis = basis.rotateIJ(Math.toRadians(this.rotationAroundZInDegree));
        long t1 = System.nanoTime();
        SpherePolyhedraVoxelBuilder builder = this.resultType.newVoxelBuilder(spherePolyhedra, this.resultType.elementType(kindSet), this);
        builder.setVoxelOrigin(originX, originY, originZ);
        builder.setSpherePolyhedraOrigin(this.spherePolyhedraOriginX, this.spherePolyhedraOriginY, this.spherePolyhedraOriginZ);
        builder.setRotationBasis(basis);
        builder.setScaleX(this.scaleX);
        builder.setScaleY(this.scaleY == null ? this.scaleX : this.scaleY);
        builder.setScaleZ(this.scaleZ == null ? this.scaleX : this.scaleZ);
        SpherePolyhedraVoxelBuilder.VoxelValueSelector voxelValueSelector = this.resultType.voxelValueSelector(kindSet);
        builder.setVoxelValueSelector((sp, objectIndex, spherePolyhedronIndex) -> {
            if (kindsExist) {
                long kindId = sp.getKindId(spherePolyhedronIndex);
                if (kindId <= 0L && !this.processUnknownAndSystemKinds) {
                    return -1;
                }
                if (useOnlyKinds && !onlyKindIds.contains(kindId)) {
                    return -1;
                }
            }
            return voxelValueSelector.value(sp, objectIndex, spherePolyhedronIndex);
        });
        long t2 = System.nanoTime();
        builder.build();
        long t3 = System.nanoTime();
        Matrix<? extends UpdatablePArray> voxels = builder.voxels();
        MultiMatrix resultIndexes = this.resultType.toMultiMatrix(voxels, kindSet);
        Matrix<? extends UpdatablePArray> resultDistances = builder.voxelDistances();
        long t4 = System.nanoTime();
        ConvertSpherePolyhedraToVoxels.logDebug(() -> String.format(Locale.US, "Building voxels for %s: %.3f ms = %.3f allocating, %.3f building, %.3f returning image", spherePolyhedra, (double)(t4 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6));
        this.setEndProcessingTimeStamp();
        this.getScalar("number_of_objects").setTo(spherePolyhedra.numberOfObjects());
        this.getMat().setTo(resultIndexes);
        if (resultDistances != null) {
            this.getMat(OUTPUT_DISTANCES).setTo(MultiMatrix.ofMono(resultDistances));
        }
    }

    private static MultiMatrix convertToColor(Matrix<? extends PArray> voxels, Color[] palette) {
        if (voxels.size() > Integer.MAX_VALUE) {
            throw new TooLargeArrayException("Too large voxel matrix to convert to color: " + String.valueOf(voxels));
        }
        assert (voxels.elementType() == Byte.TYPE);
        assert (palette.length == 256);
        ByteArray voxelArray = (ByteArray)voxels.array();
        int size = (int)voxels.size();
        byte[][] rgbTables = new byte[3][256];
        for (int k = 0; k < 256; ++k) {
            rgbTables[0][k] = (byte)palette[k].getRed();
            rgbTables[1][k] = (byte)palette[k].getGreen();
            rgbTables[2][k] = (byte)palette[k].getBlue();
        }
        ArrayList<Matrix> channels = new ArrayList<Matrix>();
        for (byte[] table : rgbTables) {
            byte[] result = new byte[size];
            IntStream.range(0, result.length + 255 >>> 8).parallel().forEach(block -> {
                int i;
                int to = (int)Math.min((long)i + 256L, (long)result.length);
                for (i = block << 8; i < to; ++i) {
                    result[i] = table[voxelArray.getByte((long)i)];
                }
            });
            channels.add(voxels.matrix((Array)ByteArray.as((byte[])result)));
        }
        return MultiMatrix.ofRGBA(channels);
    }

    public static final class ResultType
    extends Enum<ResultType> {
        public static final /* enum */ ResultType BINARY = new ResultType();
        public static final /* enum */ ResultType OBJECT_INDEX = new ResultType();
        public static final /* enum */ ResultType LABEL = new ResultType();
        public static final /* enum */ ResultType COLOR = new ResultType();
        private static final /* synthetic */ ResultType[] $VALUES;

        public static ResultType[] values() {
            return (ResultType[])$VALUES.clone();
        }

        public static ResultType valueOf(String name) {
            return Enum.valueOf(ResultType.class, name);
        }

        MultiMatrix toMultiMatrix(Matrix<? extends PArray> voxels, SpherePolyhedronKindSet kindSet) {
            if (this != COLOR) {
                return MultiMatrix.ofMono(voxels);
            }
            Object[] palette = new Color[256];
            Arrays.fill(palette, Color.BLACK);
            for (SpherePolyhedronKind kind : kindSet.allFirstKinds()) {
                int label = kind.getLabel();
                assert (label >= 0 && label < 256) : "Min/max labels were not correctly checked in elementType()";
                palette[label] = kind.getColor();
            }
            return ConvertSpherePolyhedraToVoxels.convertToColor(voxels, (Color[])palette);
        }

        public Class<?> elementType(SpherePolyhedronKindSet kindSet) {
            switch (this.ordinal()) {
                case 0: {
                    return Boolean.TYPE;
                }
                case 1: {
                    return Integer.TYPE;
                }
                case 2: 
                case 3: {
                    if (kindSet == null) {
                        throw new IllegalArgumentException("kind_set must be specified for " + String.valueOf((Object)this) + " result type");
                    }
                    int minLabel = kindSet.getMinFirstLabel();
                    int maxLabel = kindSet.getMaxFirstLabel();
                    if (this == COLOR) {
                        if (minLabel < 0) {
                            throw new IllegalArgumentException("Negative label " + minLabel + " found; it is prohibited for color results");
                        }
                        if (maxLabel >= 256) {
                            throw new IllegalArgumentException("Too large label " + maxLabel + ">255 found; it is prohibited for color results");
                        }
                    }
                    if (minLabel >= 0) {
                        if (maxLabel < 256) {
                            return Byte.TYPE;
                        }
                        if (maxLabel < 65536) {
                            return Short.TYPE;
                        }
                    }
                    return Integer.TYPE;
                }
            }
            throw new AssertionError();
        }

        public SpherePolyhedraVoxelBuilder.VoxelValueSelector voxelValueSelector(SpherePolyhedronKindSet kindSet) {
            switch (this.ordinal()) {
                case 0: {
                    return SpherePolyhedraVoxelBuilder.VoxelValueSelector.CONSTANT_1;
                }
                case 1: {
                    return SpherePolyhedraVoxelBuilder.VoxelValueSelector.INCREMENTED_OBJECT_INDEX_SELECTOR;
                }
                case 2: 
                case 3: {
                    if (kindSet == null) {
                        throw new IllegalArgumentException("kind_set must be specified for " + String.valueOf((Object)this) + " result type");
                    }
                    return (spherePolyhedra, objectIndex, spherePolyhedronIndex) -> kindSet.getFirstLabel(spherePolyhedra.getKindId(objectIndex), -1);
                }
            }
            throw new AssertionError();
        }

        public SpherePolyhedraVoxelBuilder newVoxelBuilder(SpherePolyhedra spherePolyhedra, Class<?> elementType, ConvertSpherePolyhedraToVoxels c) {
            if (c.distanceMetric == null || this == BINARY && c.distancesMode == SpherePolyhedraVoxelBuilder.BuildingDistancesMode.NONE) {
                return SpherePolyhedraVoxelBuilder.newSimpleBuilder(spherePolyhedra, elementType, c.dimX, c.dimY, c.dimZ);
            }
            return SpherePolyhedraVoxelBuilder.newDistanceMapBuilder(spherePolyhedra, elementType, c.dimX, c.dimY, c.dimZ, c.distancesMode, c.distanceMetric).setMaxDistanceToObjects(c.maxDistanceToObjects);
        }

        private static /* synthetic */ ResultType[] $values() {
            return new ResultType[]{BINARY, OBJECT_INDEX, LABEL, COLOR};
        }

        static {
            $VALUES = ResultType.$values();
        }
    }
}

