/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.statistics;

import java.util.Locale;
import net.algart.arrays.Arrays;
import net.algart.arrays.MutableIntArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraProcessor;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.IntersectingNeighboursFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;

public final class SimpleSpherePolyhedraInfo
extends SpherePolyhedraProcessor {
    public static final String OUTPUT_GRAPH = "graph";
    public static final String OUTPUT_NUMBERS_OF_NEIGHBOURS = "numbers_of_neighbours";
    public static final String OUTPUT_AVERAGE_NUMBER_OF_NEIGHBOURS = "average_number_of_neighbours";
    public static final String OUTPUT_SUMMARY_VOLUME = "summary_volume";

    public SimpleSpherePolyhedraInfo() {
        this.useVisibleResultParameter();
        this.addOutputScalar("number_of_objects");
        this.setDefaultOutputNumbers(OUTPUT_GRAPH);
        this.addOutputNumbers(OUTPUT_NUMBERS_OF_NEIGHBOURS);
        this.addOutputScalar(OUTPUT_AVERAGE_NUMBER_OF_NEIGHBOURS);
        this.addOutputNumbers("parallelepiped");
        this.addOutputNumbers("parallelepiped_without_system");
        this.addOutputScalar(OUTPUT_SUMMARY_VOLUME);
    }

    public void process() {
        long t1 = System.nanoTime();
        SpherePolyhedronKindSet kindSet = this.deserializeKindSetWithoutProbabilities(true);
        long t2 = System.nanoTime();
        SpherePolyhedra spherePolyhedra = SimpleSpherePolyhedraInfo.deserializeSpherePolyhedra(this);
        long t3 = System.nanoTime();
        boolean needGraph = this.isOutputNecessary(OUTPUT_GRAPH) || this.isOutputNecessary(OUTPUT_NUMBERS_OF_NEIGHBOURS) || this.isOutputNecessary(OUTPUT_AVERAGE_NUMBER_OF_NEIGHBOURS);
        SNumbers graph = null;
        SNumbers numbersOfNeighbours = null;
        double averageNumberOfObjects = Double.NaN;
        if (needGraph) {
            graph = new SNumbers();
            numbersOfNeighbours = new SNumbers();
            this.buildObjectGraph(spherePolyhedra, graph, numbersOfNeighbours);
            averageNumberOfObjects = (double)graph.n() / (double)spherePolyhedra.numberOfObjects();
        }
        long t4 = System.nanoTime();
        this.getScalar("number_of_objects").setTo(spherePolyhedra.numberOfObjects());
        if (needGraph) {
            this.getNumbers(OUTPUT_GRAPH).exchange(graph);
            this.getNumbers(OUTPUT_NUMBERS_OF_NEIGHBOURS).exchange(numbersOfNeighbours);
            this.getScalar(OUTPUT_AVERAGE_NUMBER_OF_NEIGHBOURS).setTo(averageNumberOfObjects);
        }
        if (this.isOutputNecessary("parallelepiped")) {
            SpherePolyhedraTools.serializeParallelepiped(this, spherePolyhedra.containingAllParallelepiped(), "parallelepiped");
        }
        if (this.isOutputNecessary("parallelepiped_without_system")) {
            SpherePolyhedra clone = spherePolyhedra.clone();
            clone.removeObjects(objectIndex -> clone.getObjectKindId(objectIndex) <= 0L);
            SpherePolyhedraTools.serializeParallelepiped(this, clone.containingAllParallelepiped(), "parallelepiped_without_system");
        }
        this.getScalar(OUTPUT_SUMMARY_VOLUME).setTo(spherePolyhedra.summaryVolume());
        long t5 = System.nanoTime();
        SimpleSpherePolyhedraInfo.logDebug(() -> String.format(Locale.US, "Analysing %s: %.3f ms = %.3f + %.3f deserializing, %.3f processing graph, %.3f post-processing", spherePolyhedra, (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
    }

    public void buildObjectGraph(SpherePolyhedra spherePolyhedra, SNumbers resultGraph, SNumbers resultNumbersOfNeighbours) {
        IntersectingNeighboursFinder finder = new IntersectingNeighboursFinder(spherePolyhedra, false);
        MutableIntArray pairs = Arrays.SMM.newEmptyIntArray();
        MutableIntArray numbersOfNeighbours = Arrays.SMM.newEmptyIntArray();
        int n = spherePolyhedra.numberOfObjects();
        for (int objectIndex = 0; objectIndex < n; ++objectIndex) {
            finder.findNeighboursOfObject(objectIndex);
            int m = finder.numberOfNeighbours();
            for (int i = 0; i < m; ++i) {
                pairs.pushInt(objectIndex);
                pairs.pushInt(finder.neighbour(i));
            }
            numbersOfNeighbours.pushInt(m);
        }
        pairs.pushInt(n - 1);
        pairs.pushInt(n - 1);
        resultGraph.setTo((PNumberArray)pairs, 2);
        resultNumbersOfNeighbours.setTo((PNumberArray)numbersOfNeighbours, 1);
    }
}

