/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.packing;

import java.util.Locale;
import java.util.Random;
import net.algart.contexts.InterruptionException;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraFilter;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.BestTouchingPositionFinder;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionModifier;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrionRandomRotator;
import net.algart.model3d.spherepolyhedra.packing.ImpossibleToPackException;
import net.algart.model3d.spherepolyhedra.packing.SpherePolyhedraPacker;

public abstract class AbstractPackSpherePolyhedra
extends SpherePolyhedraFilter {
    public static final String NUMBER_OF_ATTEMPTS = "number_of_attempts";
    public static final String NUMBER_OF_SUCCESSES = "number_of_successes";
    public static final String NUMBER_OF_FAILURES = "number_of_failures";
    final BestTouchingPositionFinder.Settings pfs = new BestTouchingPositionFinder.Settings();
    private Long randSeed = null;
    private int numberOfObjects = 10;
    private int numberOfCheckedPositions = 1;
    private boolean randomRotation = false;
    private String onlyKinds = "";
    private boolean usePackingRestrictions = true;
    private boolean samePackingRestrictionsForOneKindId = true;
    private boolean newPackedObjectsMayOverlap = false;
    private int numberOfCreationsBeforeFailure = 10;
    private boolean silentInterrupting = false;

    protected AbstractPackSpherePolyhedra() {
        this.addInputScalar("packing_geometry");
        this.addOutputScalar("packing_geometry");
        this.addOutputNumbers("parallelepiped");
        this.addOutputNumbers("parallelepiped_without_system");
        this.addOutputScalar("friendly_kinds_list");
        this.addOutputScalar(NUMBER_OF_ATTEMPTS);
        this.addOutputScalar(NUMBER_OF_SUCCESSES);
        this.addOutputScalar(NUMBER_OF_FAILURES);
    }

    public Long getRandSeed() {
        return this.randSeed;
    }

    public AbstractPackSpherePolyhedra setRandSeed(Long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    public int getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public AbstractPackSpherePolyhedra setNumberOfObjects(int numberOfObjects) {
        this.numberOfObjects = AbstractPackSpherePolyhedra.nonNegative((int)numberOfObjects);
        return this;
    }

    public int getNumberOfCheckedPositions() {
        return this.numberOfCheckedPositions;
    }

    public AbstractPackSpherePolyhedra setNumberOfCheckedPositions(int numberOfCheckedPositions) {
        this.numberOfCheckedPositions = AbstractPackSpherePolyhedra.positive((int)numberOfCheckedPositions);
        return this;
    }

    public boolean isRandomRotation() {
        return this.randomRotation;
    }

    public AbstractPackSpherePolyhedra setRandomRotation(boolean randomRotation) {
        this.randomRotation = randomRotation;
        return this;
    }

    public BestTouchingPositionFinder.Settings.FirstPositionStrategy getFirstPositionStrategy() {
        return this.pfs.getFirstPositionStrategy();
    }

    public AbstractPackSpherePolyhedra setFirstPositionStrategy(BestTouchingPositionFinder.Settings.FirstPositionStrategy firstPositionStrategy) {
        this.pfs.setFirstPositionStrategy(firstPositionStrategy);
        return this;
    }

    public boolean isUseGeometryForFirstPosition() {
        return this.pfs.isUseGeometry();
    }

    public AbstractPackSpherePolyhedra setUseGeometryForFirstPosition(boolean useGeometry) {
        this.pfs.setUseGeometry(useGeometry);
        return this;
    }

    public String getOnlyKinds() {
        return this.onlyKinds;
    }

    public AbstractPackSpherePolyhedra setOnlyKinds(String onlyKinds) {
        this.onlyKinds = (String)AbstractPackSpherePolyhedra.nonNull((Object)onlyKinds);
        return this;
    }

    public boolean isUsePackingRestrictions() {
        return this.usePackingRestrictions;
    }

    public AbstractPackSpherePolyhedra setUsePackingRestrictions(boolean usePackingRestrictions) {
        this.usePackingRestrictions = usePackingRestrictions;
        return this;
    }

    public boolean isSamePackingRestrictionsForOneKindId() {
        return this.samePackingRestrictionsForOneKindId;
    }

    public AbstractPackSpherePolyhedra setSamePackingRestrictionsForOneKindId(boolean samePackingRestrictionsForOneKindId) {
        this.samePackingRestrictionsForOneKindId = samePackingRestrictionsForOneKindId;
        return this;
    }

    public boolean isNewPackedObjectsMayOverlap() {
        return this.newPackedObjectsMayOverlap;
    }

    public AbstractPackSpherePolyhedra setNewPackedObjectsMayOverlap(boolean newPackedObjectsMayOverlap) {
        this.newPackedObjectsMayOverlap = newPackedObjectsMayOverlap;
        return this;
    }

    public int getNumberOfCreationsBeforeFailure() {
        return this.numberOfCreationsBeforeFailure;
    }

    public AbstractPackSpherePolyhedra setNumberOfCreationsBeforeFailure(int numberOfCreationsBeforeFailure) {
        this.numberOfCreationsBeforeFailure = AbstractPackSpherePolyhedra.nonNegative((int)numberOfCreationsBeforeFailure);
        return this;
    }

    public boolean isSilentInterrupting() {
        return this.silentInterrupting;
    }

    public AbstractPackSpherePolyhedra setSilentInterrupting(boolean silentInterrupting) {
        this.silentInterrupting = silentInterrupting;
        return this;
    }

    public void process() {
        long t1 = AbstractPackSpherePolyhedra.debugTime();
        SpherePolyhedronKindSet allKinds = this.deserializeKindSetAndProbabilities();
        SpherePolyhedronKindSet kindSet = allKinds.selectKinds(this.onlyKinds);
        long t2 = AbstractPackSpherePolyhedra.debugTime();
        SpherePolyhedraPackingGeometry packingGeometry = this.deserializePackingGeometry();
        long t3 = AbstractPackSpherePolyhedra.debugTime();
        SpherePolyhedra spherePolyhedra = this.deserializeSpherePolyhedra();
        this.setStartProcessingTimeStamp();
        AbstractPackSpherePolyhedra.logDebug(() -> "Packing " + this.numberOfObjects + " sphere-polyhedra (or unions) by " + String.valueOf((Object)this) + ", basing on " + String.valueOf(kindSet) + ", starting from " + String.valueOf(spherePolyhedra));
        long t4 = AbstractPackSpherePolyhedra.debugTime();
        int initial = spherePolyhedra.numberOfObjects();
        int attempts = this.process(spherePolyhedra, packingGeometry, kindSet);
        int successes = spherePolyhedra.numberOfObjects() - initial;
        long t5 = AbstractPackSpherePolyhedra.debugTime();
        this.setEndProcessingTimeStamp();
        this.getScalar(NUMBER_OF_ATTEMPTS).setTo(attempts);
        this.getScalar(NUMBER_OF_SUCCESSES).setTo(successes);
        this.getScalar(NUMBER_OF_FAILURES).setTo(attempts - successes);
        this.serializeKindSet(allKinds);
        long t6 = AbstractPackSpherePolyhedra.debugTime();
        this.serializePackingGeometry(packingGeometry);
        long t7 = AbstractPackSpherePolyhedra.debugTime();
        this.serializeSpherePolyhedra(spherePolyhedra);
        long t8 = AbstractPackSpherePolyhedra.debugTime();
        this.serializeFriendlyKinds(spherePolyhedra, allKinds);
        long t9 = AbstractPackSpherePolyhedra.debugTime();
        if (LOGGABLE_DEBUG) {
            AbstractPackSpherePolyhedra.logDebug((String)String.format(Locale.US, "Packed %d/%d sphere-polyhedra (or unions) by %d attempts in %.3f ms (%.3f mcs/attempt); also loading configuration %.3f ms kind set + %.3f ms geometry + %.3f ms objects and saving %.3f ms kind set + %.3f ms geometry + %.3f ms objects + %.3f ms friendly", spherePolyhedra.numberOfObjects(), this.numberOfObjects, attempts, (double)(t5 - t4) * 1.0E-6, (double)(t5 - t4) * 0.001 / (double)attempts, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t6 - t5) * 1.0E-6, (double)(t7 - t6) * 1.0E-6, (double)(t8 - t7) * 1.0E-6, (double)(t9 - t8) * 1.0E-6));
        }
    }

    public int process(SpherePolyhedra spherePolyhedra, SpherePolyhedraPackingGeometry packingGeometry, SpherePolyhedronKindSet kindSet) {
        if (spherePolyhedra.isEmpty()) {
            packingGeometry.buildInitialSpherePolyhedra(spherePolyhedra);
        }
        SpherePolyhedraPacker packer = this.createPacker(spherePolyhedra, packingGeometry, this.randSeed == null ? new Random().nextLong() : this.randSeed.longValue());
        packer.setModifier(this.randomRotation ? new SpherePolyhedrionRandomRotator() : SpherePolyhedrionModifier.EMPTY);
        packer.setNumberOfCheckedPositions(this.numberOfCheckedPositions);
        if (this.usePackingRestrictions) {
            packer.setRestrictionFactory(kindSet);
        }
        int attempts = 0;
        SpherePolyhedra resultSpherePolyhedra = this.newPackedObjectsMayOverlap ? SpherePolyhedra.newEmpty() : spherePolyhedra;
        for (int i = 0; i < this.numberOfObjects; ++i) {
            try {
                attempts += this.tryToCreateAndPack(packer, resultSpherePolyhedra, kindSet, i + 1);
                int index = i + 1;
                this.showStatus(() -> "Packed " + index + "/" + this.numberOfObjects + " objects");
                if (!this.isInterrupted()) continue;
                if (this.silentInterrupting) break;
                throw new InterruptionException("Packing sphere-polyhedra was interrupted after the object #" + i + "/" + this.numberOfObjects);
            }
            catch (ImpossibleToPackException e) {
                LOG.log(System.Logger.Level.INFO, "Cannot create and pack sphere-polyhedron #" + (i + 1) + " after " + this.numberOfCreationsBeforeFailure + " attempts: " + e.getMessage() + "; last of them was " + String.valueOf(e.spherePolyhedron()));
                break;
            }
        }
        if (this.newPackedObjectsMayOverlap) {
            spherePolyhedra.addObjects(resultSpherePolyhedra);
        }
        return attempts;
    }

    public int tryToCreateAndPack(SpherePolyhedraPacker packer, SpherePolyhedra resultSpherePolyhedra, SpherePolyhedronKindSet kindSet, int indexForLogging) throws ImpossibleToPackException {
        int attempt = 1;
        while (true) {
            SpherePolyhedronKind kind = kindSet.nextKind(packer.getRandom());
            SpherePolyhedrion spherePolyhedrion = kind.newSpherePolyhedrion(packer.getRandom());
            if (this.usePackingRestrictions && !this.samePackingRestrictionsForOneKindId) {
                packer.setRestrictionFactory(kind);
            }
            this.modifyPacker(packer, spherePolyhedrion);
            SpherePolyhedrion newPacked = packer.tryFind(spherePolyhedrion, kind);
            String error = null;
            if (newPacked == null) {
                error = "Cannot find suitable position";
            } else if (!packer.geometry().isPositionAllowed(newPacked)) {
                error = "Newly packed object violates geometry packing requirements";
            }
            if (error != null) {
                if (this.numberOfCreationsBeforeFailure == 0) break;
                if (attempt >= this.numberOfCreationsBeforeFailure) {
                    throw new ImpossibleToPackException(error, newPacked == null ? spherePolyhedrion : newPacked);
                }
                if (LOGGABLE_TRACE) {
                    AbstractPackSpherePolyhedra.logTrace((String)("Problem with packing object #" + indexForLogging + " (" + attempt + " attempts): " + error));
                }
            } else {
                resultSpherePolyhedra.add(newPacked);
                break;
            }
            ++attempt;
        }
        return attempt;
    }

    protected abstract SpherePolyhedraPacker createPacker(SpherePolyhedra var1, SpherePolyhedraPackingGeometry var2, long var3);

    protected void modifyPacker(SpherePolyhedraPacker packer, SpherePolyhedrion spherePolyhedrion) {
    }
}

