/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.objects;

import java.util.Set;
import net.algart.executors.api.data.Data;
import net.algart.executors.api.data.SNumbers;
import net.algart.executors.api.graalvm.js.scriptengine.JavaScriptPerformer;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraFilter;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.objects.GeneratrixSphere;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;

public final class TransformSpherePolyhedra
extends SpherePolyhedraFilter {
    private double shiftX = 0.0;
    private double shiftY = 0.0;
    private double shiftZ = 0.0;
    private double dr = 0.0;
    private String drFormula = null;
    private double minRadius = 0.0;
    private boolean processUnknownAndSystemKinds = false;
    private String onlyKinds = "";
    private JavaScriptPerformer javaScriptDrFormula = null;

    public TransformSpherePolyhedra() {
        this.removeOutputPort("containing_object_indexes");
        this.removeOutputPort("first_sphere_polyhedron_indexes");
    }

    public double getShiftX() {
        return this.shiftX;
    }

    public TransformSpherePolyhedra setShiftX(double shiftX) {
        this.shiftX = shiftX;
        return this;
    }

    public double getShiftY() {
        return this.shiftY;
    }

    public TransformSpherePolyhedra setShiftY(double shiftY) {
        this.shiftY = shiftY;
        return this;
    }

    public double getShiftZ() {
        return this.shiftZ;
    }

    public TransformSpherePolyhedra setShiftZ(double shiftZ) {
        this.shiftZ = shiftZ;
        return this;
    }

    public String getDr() {
        return this.drFormula != null ? this.drFormula : String.valueOf(this.dr);
    }

    public TransformSpherePolyhedra setDr(String dr) {
        this.drFormula = null;
        try {
            this.dr = Double.parseDouble(dr);
        }
        catch (NumberFormatException e) {
            this.dr = Double.NaN;
            this.drFormula = dr;
        }
        return this;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public TransformSpherePolyhedra setMinRadius(double minRadius) {
        this.minRadius = TransformSpherePolyhedra.nonNegative((double)minRadius);
        return this;
    }

    public boolean isProcessUnknownAndSystemKinds() {
        return this.processUnknownAndSystemKinds;
    }

    public TransformSpherePolyhedra setProcessUnknownAndSystemKinds(boolean processUnknownAndSystemKinds) {
        this.processUnknownAndSystemKinds = processUnknownAndSystemKinds;
        return this;
    }

    public String getOnlyKinds() {
        return this.onlyKinds;
    }

    public TransformSpherePolyhedra setOnlyKinds(String onlyKinds) {
        this.onlyKinds = (String)TransformSpherePolyhedra.nonNull((Object)onlyKinds);
        return this;
    }

    public void process() {
        SNumbers inputNumbers = this.getInputNumbers("xyzr", true).requireBlockLength(4, "xyzr");
        SerializedSpherePolyhedra serializedSpherePolyhedra = this.retrieveSpherePolyhedra();
        SNumbers inputKinds = this.getInputNumbers("kinds", true);
        if (inputNumbers.isInitialized()) {
            long[] kinds = inputKinds.toLongArray();
            double[] xyzr = inputNumbers.toDoubleArray();
            int step = this.process(kinds, xyzr);
            this.getNumbers("xyzr").setTo(xyzr, step);
        }
        this.getNumbers("generatrix_sets").exchange(this.getInputNumbers("generatrix_sets", true));
        this.getNumbers("kinds").exchange(inputKinds);
        this.getScalar("kind_set").exchange((Data)this.getInputScalar("kind_set", true));
        this.getScalar("number_of_objects").setTo(serializedSpherePolyhedra.numberOfObjects());
    }

    public int process(long[] kinds, double[] xyzr) {
        int step = 4;
        Set<Long> onlyKindIds = SpherePolyhedronKind.splitKindIds(this.onlyKinds);
        this.javaScriptDrFormula = this.drFormula == null ? null : JavaScriptPerformer.newInstanceIfChanged((String)this.drFormula, (JavaScriptPerformer)this.javaScriptDrFormula);
        boolean useOnlyKinds = !this.onlyKinds.trim().isEmpty();
        int k = 0;
        for (int i = 0; i < xyzr.length; i += 4) {
            long kindId;
            if (kinds == null || k >= kinds.length || ((kindId = kinds[k]) > 0L || this.processUnknownAndSystemKinds) && (!useOnlyKinds || onlyKindIds.contains(kindId))) {
                int n = i;
                xyzr[n] = xyzr[n] + this.shiftX;
                int n2 = i + 1;
                xyzr[n2] = xyzr[n2] + this.shiftY;
                int n3 = i + 2;
                xyzr[n3] = xyzr[n3] + this.shiftZ;
                double r = xyzr[i + 3];
                if ((r += this.evalDr(kinds, xyzr, k)) < this.minRadius) {
                    r = this.minRadius;
                }
                GeneratrixSphere.checkRadius(r);
                xyzr[i + 3] = r;
            }
            ++k;
        }
        return 4;
    }

    private double evalDr(long[] kinds, double[] xyzr, int k) {
        if (this.javaScriptDrFormula == null) {
            return this.dr;
        }
        int i = 4 * k;
        this.javaScriptDrFormula.putVariable("x", (Object)xyzr[i++]);
        this.javaScriptDrFormula.putVariable("y", (Object)xyzr[i++]);
        this.javaScriptDrFormula.putVariable("z", (Object)xyzr[i++]);
        this.javaScriptDrFormula.putVariable("r", (Object)xyzr[i]);
        String kind = null;
        long kindId = 0L;
        if (kinds != null && k < kinds.length) {
            kindId = kinds[k];
            kind = SpherePolyhedronKind.idToFriendlyString(kindId);
        }
        this.javaScriptDrFormula.putVariable("kindId", (Object)kindId);
        this.javaScriptDrFormula.putVariable("kind", (Object)kind);
        return this.javaScriptDrFormula.calculateDouble();
    }
}

