/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.objects;

import java.util.Random;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraGenerator;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedrion;

public final class CreateRandomSpherePolyhedra
extends SpherePolyhedraGenerator {
    public static final String INPUT_KIND_SET = "kind_set";
    private Long randSeed = null;
    private int numberOfSpherePolyhedra = 10;
    private String onlyKinds = "";

    public CreateRandomSpherePolyhedra() {
        this.setDefaultInputScalar(INPUT_KIND_SET);
    }

    public Long getRandSeed() {
        return this.randSeed;
    }

    public CreateRandomSpherePolyhedra setRandSeed(Long randSeed) {
        this.randSeed = randSeed;
        return this;
    }

    public CreateRandomSpherePolyhedra setRandSeed(String randSeed) {
        return this.setRandSeed(CreateRandomSpherePolyhedra.longOrNull((String)randSeed));
    }

    public int getNumberOfSpherePolyhedra() {
        return this.numberOfSpherePolyhedra;
    }

    public CreateRandomSpherePolyhedra setNumberOfSpherePolyhedra(int numberOfSpherePolyhedra) {
        this.numberOfSpherePolyhedra = CreateRandomSpherePolyhedra.nonNegative((int)numberOfSpherePolyhedra);
        return this;
    }

    public String getOnlyKinds() {
        return this.onlyKinds;
    }

    public CreateRandomSpherePolyhedra setOnlyKinds(String onlyKinds) {
        this.onlyKinds = (String)CreateRandomSpherePolyhedra.nonNull((Object)onlyKinds);
        return this;
    }

    public void process() {
        SpherePolyhedronKindSet allKinds = this.deserializeKindSetAndProbabilities();
        SpherePolyhedronKindSet kindSet = allKinds.selectKinds(this.onlyKinds);
        Random random = this.randSeed == null ? new Random() : new Random(this.randSeed);
        CreateRandomSpherePolyhedra.logDebug(() -> "Building " + this.numberOfSpherePolyhedra + " sphere-polyhedron (or unions), basing on  " + String.valueOf(allKinds));
        SpherePolyhedra spherePolyhedra = SpherePolyhedra.newEmpty();
        for (int k = 0; k < this.numberOfSpherePolyhedra; ++k) {
            SpherePolyhedronKind kind = kindSet.nextKind(random);
            SpherePolyhedrion spherePolyhedrion = kind.newSpherePolyhedrion(random);
            spherePolyhedra.add(spherePolyhedrion);
        }
        this.serializeSpherePolyhedra(spherePolyhedra);
        this.serializeKindSet(allKinds);
    }
}

