/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.geometries;

import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.json.Jsons;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.geometries.VerticalRectangularBox;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;

public final class CreateVerticalRectangularBoxGeometry
extends ScalarFilter {
    private Double centerI = 0.0;
    private Double centerJ = 0.0;
    private Double bottomK = 0.0;
    private Double sizeI = 20.0;
    private Double sizeJ = 20.0;
    private Double sizeK = 20.0;
    private boolean allowOverflow = true;
    private Double ix = 1.0;
    private Double iy = 0.0;
    private Double iz = 0.0;
    private Double jx = 0.0;
    private Double jy = 1.0;
    private Double jz = 0.0;
    private String leftWallKindId = "";
    private String rightWallKindId = "";
    private String frontWallKindId = "";
    private String rearWallKindId = "";
    private String bottomKindId = "";

    public CreateVerticalRectangularBoxGeometry() {
        this.setDefaultInputScalar("packing_geometry");
        this.setDefaultOutputScalar("packing_geometry");
    }

    public Double getCenterI() {
        return this.centerI;
    }

    public CreateVerticalRectangularBoxGeometry setCenterI(Double centerI) {
        this.centerI = centerI;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setCenterI(String centerI) {
        return this.setCenterI(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)centerI));
    }

    public Double getCenterJ() {
        return this.centerJ;
    }

    public CreateVerticalRectangularBoxGeometry setCenterJ(Double centerJ) {
        this.centerJ = centerJ;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setCenterJ(String centerJ) {
        return this.setCenterJ(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)centerJ));
    }

    public Double getBottomK() {
        return this.bottomK;
    }

    public CreateVerticalRectangularBoxGeometry setBottomK(Double bottomK) {
        this.bottomK = bottomK;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setBottomK(String bottomK) {
        return this.setBottomK(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)bottomK));
    }

    public Double getSizeI() {
        return this.sizeI;
    }

    public CreateVerticalRectangularBoxGeometry setSizeI(Double sizeI) {
        this.sizeI = sizeI;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setSizeI(String sizeI) {
        return this.setSizeI(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)sizeI));
    }

    public Double getSizeJ() {
        return this.sizeJ;
    }

    public CreateVerticalRectangularBoxGeometry setSizeJ(Double sizeJ) {
        this.sizeJ = sizeJ;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setSizeJ(String sizeJ) {
        return this.setSizeJ(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)sizeJ));
    }

    public Double getSizeK() {
        return this.sizeK;
    }

    public CreateVerticalRectangularBoxGeometry setSizeK(Double sizeK) {
        this.sizeK = sizeK;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setSizeK(String sizeK) {
        return this.setSizeK(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)sizeK));
    }

    public Double getIx() {
        return this.ix;
    }

    public CreateVerticalRectangularBoxGeometry setIx(Double ix) {
        this.ix = ix;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setIx(String ix) {
        return this.setIx(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)ix));
    }

    public Double getIy() {
        return this.iy;
    }

    public CreateVerticalRectangularBoxGeometry setIy(Double iy) {
        this.iy = iy;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setIy(String iy) {
        return this.setIy(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)iy));
    }

    public Double getIz() {
        return this.iz;
    }

    public CreateVerticalRectangularBoxGeometry setIz(Double iz) {
        this.iz = iz;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setIz(String iz) {
        return this.setIz(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)iz));
    }

    public Double getJx() {
        return this.jx;
    }

    public CreateVerticalRectangularBoxGeometry setJx(Double jx) {
        this.jx = jx;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setJx(String jx) {
        return this.setJx(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)jx));
    }

    public Double getJy() {
        return this.jy;
    }

    public CreateVerticalRectangularBoxGeometry setJy(Double jy) {
        this.jy = jy;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setJy(String jy) {
        return this.setJy(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)jy));
    }

    public Double getJz() {
        return this.jz;
    }

    public CreateVerticalRectangularBoxGeometry setJz(Double jz) {
        this.jz = jz;
        return this;
    }

    public CreateVerticalRectangularBoxGeometry setJz(String jz) {
        return this.setJz(CreateVerticalRectangularBoxGeometry.doubleOrNull((String)jz));
    }

    public boolean isAllowOverflow() {
        return this.allowOverflow;
    }

    public CreateVerticalRectangularBoxGeometry setAllowOverflow(boolean allowOverflow) {
        this.allowOverflow = allowOverflow;
        return this;
    }

    public String getLeftWallKindId() {
        return this.leftWallKindId;
    }

    public CreateVerticalRectangularBoxGeometry setLeftWallKindId(String leftWallKindId) {
        this.leftWallKindId = ((String)CreateVerticalRectangularBoxGeometry.nonNull((Object)leftWallKindId)).trim();
        return this;
    }

    public String getRightWallKindId() {
        return this.rightWallKindId;
    }

    public CreateVerticalRectangularBoxGeometry setRightWallKindId(String rightWallKindId) {
        this.rightWallKindId = ((String)CreateVerticalRectangularBoxGeometry.nonNull((Object)rightWallKindId)).trim();
        return this;
    }

    public String getFrontWallKindId() {
        return this.frontWallKindId;
    }

    public CreateVerticalRectangularBoxGeometry setFrontWallKindId(String frontWallKindId) {
        this.frontWallKindId = ((String)CreateVerticalRectangularBoxGeometry.nonNull((Object)frontWallKindId)).trim();
        return this;
    }

    public String getRearWallKindId() {
        return this.rearWallKindId;
    }

    public CreateVerticalRectangularBoxGeometry setRearWallKindId(String rearWallKindId) {
        this.rearWallKindId = ((String)CreateVerticalRectangularBoxGeometry.nonNull((Object)rearWallKindId)).trim();
        return this;
    }

    public String getBottomKindId() {
        return this.bottomKindId;
    }

    public CreateVerticalRectangularBoxGeometry setBottomKindId(String bottomKindId) {
        this.bottomKindId = ((String)CreateVerticalRectangularBoxGeometry.nonNull((Object)bottomKindId)).trim();
        return this;
    }

    public SScalar process(SScalar source) {
        SpherePolyhedraPackingGeometry packingGeometry;
        SpherePolyhedraPackingGeometry spherePolyhedraPackingGeometry = packingGeometry = source.isInitialized() ? SpherePolyhedraPackingGeometry.of(Jsons.toJson((String)source.getValue())) : new VerticalRectangularBox();
        if (!(packingGeometry instanceof VerticalRectangularBox)) {
            throw new IllegalArgumentException("Source packing geometry is not a vertical box");
        }
        SpherePolyhedraPackingGeometry box = packingGeometry;
        if (this.centerI != null) {
            ((VerticalRectangularBox)box).setCenterI(this.centerI);
        }
        if (this.centerJ != null) {
            ((VerticalRectangularBox)box).setCenterJ(this.centerJ);
        }
        if (this.bottomK != null) {
            ((VerticalRectangularBox)box).setBottomK(this.bottomK);
        }
        if (this.sizeI != null) {
            ((VerticalRectangularBox)box).setSizeI(this.sizeI);
        }
        if (this.sizeJ != null) {
            ((VerticalRectangularBox)box).setSizeJ(this.sizeJ);
        }
        if (this.sizeK != null) {
            ((VerticalRectangularBox)box).setSizeK(this.sizeK);
        }
        ((VerticalRectangularBox)box).setOrientation(Orthonormal3DBasis.newBasis((double)(this.ix == null ? ((VerticalRectangularBox)box).getIx() : this.ix.doubleValue()), (double)(this.iy == null ? ((VerticalRectangularBox)box).getIy() : this.iy.doubleValue()), (double)(this.iz == null ? ((VerticalRectangularBox)box).getIz() : this.iz.doubleValue()), (double)(this.jx == null ? ((VerticalRectangularBox)box).getJx() : this.jx.doubleValue()), (double)(this.jy == null ? ((VerticalRectangularBox)box).getJy() : this.jy.doubleValue()), (double)(this.jz == null ? ((VerticalRectangularBox)box).getJz() : this.jz.doubleValue()), (boolean)true));
        ((VerticalRectangularBox)box).setAllowOverflow(this.allowOverflow);
        if (!this.leftWallKindId.isEmpty()) {
            ((VerticalRectangularBox)box).setLeftWallKindId(CreateVerticalRectangularBoxGeometry.getSystemKindId(this.leftWallKindId));
        }
        if (!this.rightWallKindId.isEmpty()) {
            ((VerticalRectangularBox)box).setLeftWallKindId(CreateVerticalRectangularBoxGeometry.getSystemKindId(this.rightWallKindId));
        }
        if (!this.frontWallKindId.isEmpty()) {
            ((VerticalRectangularBox)box).setLeftWallKindId(CreateVerticalRectangularBoxGeometry.getSystemKindId(this.frontWallKindId));
        }
        if (!this.rearWallKindId.isEmpty()) {
            ((VerticalRectangularBox)box).setLeftWallKindId(CreateVerticalRectangularBoxGeometry.getSystemKindId(this.rearWallKindId));
        }
        if (!this.bottomKindId.isEmpty()) {
            ((VerticalRectangularBox)box).setLeftWallKindId(CreateVerticalRectangularBoxGeometry.getSystemKindId(this.bottomKindId));
        }
        return SScalar.of((Object)box.toJsonString());
    }

    protected boolean allowUninitializedInput() {
        return true;
    }

    private static long getSystemKindId(String friendlyId) {
        long id = SpherePolyhedronKind.friendlyStringToId(friendlyId);
        if (id > 0L) {
            throw new IllegalArgumentException("Invalid id \"" + friendlyId + "\": it is not a system id and is not allowed here");
        }
        return id;
    }
}

