/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.drawing;

import java.awt.Color;
import java.util.Locale;
import java.util.Set;
import net.algart.executors.modules.model3d.spherepolyhedra.common.SpherePolyhedraProcessor;
import net.algart.executors.modules.model3d.spherepolyhedra.drawing.DrawSpherePolyhedron;
import net.algart.math.Range;
import net.algart.math.RectangularArea;
import net.algart.math.geometry.Orthonormal3DBasis;
import net.algart.model3d.spherepolyhedra.drawing.DrawingColor;
import net.algart.model3d.spherepolyhedra.drawing.SpherePolyhedraDrawer;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKind;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedronColorSelector;
import net.algart.multimatrix.MultiMatrix;
import net.algart.multimatrix.MultiMatrix2D;

public final class DrawSpherePolyhedra
extends SpherePolyhedraProcessor {
    public static final String OUTPUT_PARALLELEPIPED = "parallelepiped";
    public static final String OUTPUT_SUMMARY_VOLUME = "summary_volume";
    private int dimX = 1000;
    private int dimY = 1000;
    private int x0 = 0;
    private int y0 = 0;
    private double scale = 1.0;
    private double rotationAroundXInDegree = 0.0;
    private double rotationAroundYInDegree = 0.0;
    private double rotationAroundZInDegree = 0.0;
    private double sectionZ = Double.POSITIVE_INFINITY;
    private boolean dissectedObjectsVisible = true;
    private Color backgroundColor = Color.WHITE;
    private Color defaultColor = Color.CYAN;
    private String invisibleKinds = "";
    private boolean axes = true;
    private boolean upwardAxisY = true;
    private boolean animate = false;
    private int animationDelay = 50;
    private Orthonormal3DBasis currentBasis = Orthonormal3DBasis.DEFAULT;
    private SpherePolyhedra currentSpherePolyhedra = null;

    public DrawSpherePolyhedra() {
        this.setDefaultOutputMat(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar("number_of_objects");
        this.addOutputNumbers(OUTPUT_PARALLELEPIPED);
        this.addOutputScalar(OUTPUT_SUMMARY_VOLUME);
    }

    public int getDimX() {
        return this.dimX;
    }

    public void setDimX(int dimX) {
        this.dimX = DrawSpherePolyhedra.positive((int)dimX);
    }

    public int getDimY() {
        return this.dimY;
    }

    public void setDimY(int dimY) {
        this.dimY = DrawSpherePolyhedra.positive((int)dimY);
    }

    public int getX0() {
        return this.x0;
    }

    public void setX0(int x0) {
        this.x0 = x0;
    }

    public int getY0() {
        return this.y0;
    }

    public void setY0(int y0) {
        this.y0 = y0;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public double getRotationAroundXInDegree() {
        return this.rotationAroundXInDegree;
    }

    public void setRotationAroundXInDegree(double rotationAroundXInDegree) {
        this.rotationAroundXInDegree = rotationAroundXInDegree;
    }

    public double getRotationAroundYInDegree() {
        return this.rotationAroundYInDegree;
    }

    public void setRotationAroundYInDegree(double rotationAroundYInDegree) {
        this.rotationAroundYInDegree = rotationAroundYInDegree;
    }

    public double getRotationAroundZInDegree() {
        return this.rotationAroundZInDegree;
    }

    public void setRotationAroundZInDegree(double rotationAroundZInDegree) {
        this.rotationAroundZInDegree = rotationAroundZInDegree;
    }

    public double getSectionZ() {
        return this.sectionZ;
    }

    public void setSectionZ(double sectionZ) {
        this.sectionZ = sectionZ;
    }

    public void setSectionZ(String sectionZ) {
        this.setSectionZ(DrawSpherePolyhedra.doubleOrPositiveInfinity((String)sectionZ));
    }

    public boolean isDissectedObjectsVisible() {
        return this.dissectedObjectsVisible;
    }

    public void setDissectedObjectsVisible(boolean dissectedObjectsVisible) {
        this.dissectedObjectsVisible = dissectedObjectsVisible;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = (Color)DrawSpherePolyhedra.nonNull((Object)backgroundColor);
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColor = (Color)DrawSpherePolyhedra.nonNull((Object)defaultColor);
    }

    public String getInvisibleKinds() {
        return this.invisibleKinds;
    }

    public void setInvisibleKinds(String invisibleKinds) {
        this.invisibleKinds = (String)DrawSpherePolyhedra.nonNull((Object)invisibleKinds);
    }

    public boolean isAxes() {
        return this.axes;
    }

    public void setAxes(boolean axes) {
        this.axes = axes;
    }

    public boolean isUpwardAxisY() {
        return this.upwardAxisY;
    }

    public void setUpwardAxisY(boolean upwardAxisY) {
        this.upwardAxisY = upwardAxisY;
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int animationDelay) {
        this.animationDelay = animationDelay;
    }

    public void process() {
        RectangularArea p;
        double drawnSectionZ;
        long t1 = System.nanoTime();
        SpherePolyhedronKindSet kindSet = this.deserializeKindSetWithoutProbabilities(true);
        if (!this.animate) {
            this.currentBasis = Orthonormal3DBasis.DEFAULT;
        }
        this.currentBasis = this.currentBasis.rotateJK(Math.toRadians(this.rotationAroundXInDegree));
        this.currentBasis = this.currentBasis.rotateKI(Math.toRadians(this.rotationAroundYInDegree));
        this.currentBasis = this.currentBasis.rotateIJ(Math.toRadians(this.rotationAroundZInDegree));
        if (!this.animate || this.currentSpherePolyhedra == null) {
            this.currentSpherePolyhedra = DrawSpherePolyhedra.deserializeSpherePolyhedra(this);
        }
        long t2 = System.nanoTime();
        SpherePolyhedraDrawer drawer = SpherePolyhedraDrawer.newOptimizedInstance(this.dimX, this.dimY, DrawingColor.of(this.backgroundColor));
        long t3 = System.nanoTime();
        if (this.sectionZ >= 1.0) {
            drawnSectionZ = Double.POSITIVE_INFINITY;
        } else {
            Range zRange = SpherePolyhedraDrawer.estimateDrawnZRange(this.currentBasis, this.scale, this.currentSpherePolyhedra);
            drawnSectionZ = zRange.min() + this.sectionZ * zRange.size();
        }
        long t4 = System.nanoTime();
        if (this.axes) {
            DrawSpherePolyhedron.drawAxes(drawer, this.dimX, this.dimY, this.dimX / 2 + this.x0, this.dimY / 2 + this.y0, this.currentBasis);
        }
        drawer.setSectionZ(drawnSectionZ);
        drawer.setDissectedObjectsVisible(this.dissectedObjectsVisible);
        drawer.setColor(DrawingColor.of(this.defaultColor));
        if (kindSet != null) {
            Set<Long> invisibleKindIds = SpherePolyhedronKind.splitKindIds(this.invisibleKinds);
            drawer.setColorSelector(spherePolyhedron -> {
                if (invisibleKindIds.contains(spherePolyhedron.kindId())) {
                    return SpherePolyhedronColorSelector.TRANSPARENT;
                }
                return kindSet.getFirstColor(spherePolyhedron);
            });
        }
        drawer.drawSpherePolyhedra(this.dimX / 2 + this.x0, this.dimY / 2 + this.y0, this.currentBasis, this.scale, this.currentSpherePolyhedra);
        long t5 = System.nanoTime();
        MultiMatrix2D drawnResult = MultiMatrix.of2DRGBA(drawer.rgbMatrices(this.upwardAxisY));
        long t6 = System.nanoTime();
        DrawSpherePolyhedra.logDebug(() -> String.format(Locale.US, "Drawing %s: %.3f ms = %.3f deserializing, %.3f preparing scene, %.3f estimating z-range, %.3f drawing, %.3f returning image", this.currentSpherePolyhedra, (double)(t6 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6, (double)(t6 - t5) * 1.0E-6));
        this.setEndProcessingTimeStamp();
        if (this.isOutputNecessary(OUTPUT_PARALLELEPIPED) && (p = this.currentSpherePolyhedra.containingAllParallelepiped()) != null) {
            this.getNumbers(OUTPUT_PARALLELEPIPED).setTo(new double[]{p.min(0), p.max(0), p.min(1), p.max(1), p.min(2), p.max(2)}, 2);
        }
        this.getScalar("number_of_objects").setTo(this.currentSpherePolyhedra.numberOfObjects());
        if (this.isOutputNecessary(OUTPUT_SUMMARY_VOLUME)) {
            this.getScalar(OUTPUT_SUMMARY_VOLUME).setTo(this.currentSpherePolyhedra.summaryVolume());
        }
        this.getMat().setTo((MultiMatrix)drawnResult);
        if (this.animate) {
            try {
                Thread.sleep(this.animationDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

