/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.model3d.spherepolyhedra.common;

import java.util.Locale;
import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.model3d.spherepolyhedra.SpherePolyhedraTools;
import net.algart.json.Jsons;
import net.algart.math.RectangularArea;
import net.algart.model3d.spherepolyhedra.geometries.SpherePolyhedraPackingGeometry;
import net.algart.model3d.spherepolyhedra.kinds.SpherePolyhedronKindSet;
import net.algart.model3d.spherepolyhedra.objects.SerializedSpherePolyhedra;
import net.algart.model3d.spherepolyhedra.objects.SpherePolyhedra;

public abstract class SpherePolyhedraExecutor
extends Executor {
    public static final String XYZR = "xyzr";
    public static final String GENERATRIX_SETS = "generatrix_sets";
    public static final String KINDS = "kinds";
    public static final String KIND_SET = "kind_set";
    public static final String FRIENDLY_KINDS_LIST = "friendly_kinds_list";
    public static final String NUMBERS_OF_GENERATRIX_SEGMENTS = "numbers_of_generatrix_segments";
    public static final String CONTAINING_OBJECT_INDEXES = "containing_object_indexes";
    public static final String FIRST_SPHERE_POLYHEDRON_INDEXES = "first_sphere_polyhedron_indexes";
    public static final String SINGLE_GENERATRIX_SET = "generatrix_set";
    public static final String PACKING_GEOMETRY = "packing_geometry";
    public static final String PARALLELEPIPED = "parallelepiped";
    public static final String PARALLELEPIPED_WITHOUT_SYSTEM = "parallelepiped_without_system";
    public static final String NUMBER_OF_OBJECTS = "number_of_objects";

    public void serializeSpherePolyhedra(SpherePolyhedra spherePolyhedra) {
        SpherePolyhedraTools.serializeSpherePolyhedra(this, spherePolyhedra, XYZR, GENERATRIX_SETS, KINDS);
        if (this.isOutputNecessary(NUMBERS_OF_GENERATRIX_SEGMENTS)) {
            this.getNumbers(NUMBERS_OF_GENERATRIX_SEGMENTS).setTo(spherePolyhedra.getAllNumbersOfGeneratrixSegments(), 1);
        }
        if (this.isOutputNecessary(CONTAINING_OBJECT_INDEXES)) {
            this.getNumbers(CONTAINING_OBJECT_INDEXES).setTo(spherePolyhedra.getAllContainingObjectIndexes(), 1);
        }
        if (this.isOutputNecessary(FIRST_SPHERE_POLYHEDRON_INDEXES)) {
            this.getNumbers(FIRST_SPHERE_POLYHEDRON_INDEXES).setTo(spherePolyhedra.getAllFirstSpherePolyhedronIndexesInObjects(), 1);
        }
        this.setOutputScalar(NUMBER_OF_OBJECTS, spherePolyhedra.numberOfObjects());
        if (this.isOutputNecessary(PARALLELEPIPED)) {
            RectangularArea parallelepiped = spherePolyhedra.containingAllParallelepiped();
            SpherePolyhedraTools.serializeParallelepiped(this, parallelepiped, PARALLELEPIPED);
        }
        if (this.isOutputNecessary(PARALLELEPIPED_WITHOUT_SYSTEM)) {
            long t1 = SpherePolyhedraExecutor.debugTime();
            SpherePolyhedra clone = spherePolyhedra.clone();
            long t2 = SpherePolyhedraExecutor.debugTime();
            clone.removeObjects(objectIndex -> spherePolyhedra.getObjectKindId(objectIndex) <= 0L);
            long t3 = SpherePolyhedraExecutor.debugTime();
            RectangularArea parallelepiped = clone.containingAllParallelepiped();
            long t4 = SpherePolyhedraExecutor.debugTime();
            SpherePolyhedraTools.serializeParallelepiped(this, parallelepiped, PARALLELEPIPED_WITHOUT_SYSTEM);
            long t5 = SpherePolyhedraExecutor.debugTime();
            SpherePolyhedraExecutor.logDebug(() -> String.format(Locale.US, "Saving containing parallelepiped without system objects: %.3f ms = %.3f clone + %.3f removing + %.3f parallelepiped + %.3f ms serializing", (double)(t5 - t1) * 1.0E-6, (double)(t2 - t1) * 1.0E-6, (double)(t3 - t2) * 1.0E-6, (double)(t4 - t3) * 1.0E-6, (double)(t5 - t4) * 1.0E-6));
        }
    }

    public SerializedSpherePolyhedra retrieveSpherePolyhedra() {
        return SpherePolyhedraExecutor.retrieveSpherePolyhedra(this);
    }

    public SpherePolyhedra deserializeSpherePolyhedra() {
        return SpherePolyhedraExecutor.deserializeSpherePolyhedra(this);
    }

    public boolean kindsExist() {
        return this.getInputNumbers(KINDS, true).isInitialized();
    }

    public void serializeKindSet(SpherePolyhedronKindSet kindSet) {
        if (kindSet != null && this.isOutputNecessary(KIND_SET)) {
            this.getScalar(KIND_SET).setTo(kindSet.toJsonString());
        }
    }

    public SpherePolyhedronKindSet deserializeKindSetAndProbabilities() {
        return this.deserializeKindSetAndProbabilities(false);
    }

    public SpherePolyhedronKindSet deserializeKindSetAndProbabilities(boolean allowUninitialized) {
        return this.deserializeKindSet(allowUninitialized, null, true);
    }

    public SpherePolyhedronKindSet deserializeKindSetWithoutProbabilities() {
        return this.deserializeKindSetWithoutProbabilities(false);
    }

    public SpherePolyhedronKindSet deserializeKindSetWithoutProbabilities(boolean allowUninitialized) {
        return this.deserializeKindSet(allowUninitialized, null, false);
    }

    public SpherePolyhedronKindSet deserializeKindSet(boolean allowUninitialized, String onlyKinds, boolean supportFractionProbabilities) {
        SScalar kindSetScalar = this.getInputScalar(KIND_SET, allowUninitialized);
        if (kindSetScalar.isInitialized()) {
            SpherePolyhedronKindSet result = SpherePolyhedronKindSet.of(Jsons.toJson((String)kindSetScalar.getValue()), supportFractionProbabilities);
            return onlyKinds != null ? result.selectKinds(onlyKinds) : result;
        }
        return null;
    }

    public void serializeFriendlyKinds(SpherePolyhedra spherePolyhedra, SpherePolyhedronKindSet kindSet) {
        if (this.isOutputNecessary(FRIENDLY_KINDS_LIST)) {
            CharSequence[] friendlyKinds = kindSet.idsToFriendlyStrings(spherePolyhedra.getAllKindIds());
            this.getScalar(FRIENDLY_KINDS_LIST).setTo(String.join((CharSequence)"\n", friendlyKinds));
        }
    }

    public void serializePackingGeometry(SpherePolyhedraPackingGeometry packingGeometry) {
        if (this.isOutputNecessary(PACKING_GEOMETRY)) {
            this.getScalar(PACKING_GEOMETRY).setTo(packingGeometry.toJsonString());
        }
    }

    public SpherePolyhedraPackingGeometry deserializePackingGeometry() {
        return SpherePolyhedraPackingGeometry.of(Jsons.toJson((String)this.getInputScalar(PACKING_GEOMETRY).getValue()));
    }

    public static SerializedSpherePolyhedra retrieveSpherePolyhedra(Executor executor) {
        return SpherePolyhedraTools.retrieveSpherePolyhedra(executor, XYZR, GENERATRIX_SETS, KINDS);
    }

    public static SpherePolyhedra deserializeSpherePolyhedra(Executor executor) {
        return SpherePolyhedraTools.deserializeSpherePolyhedra(executor, XYZR, GENERATRIX_SETS, KINDS);
    }
}

