/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import jep.Interpreter;
import jep.JepConfig;
import jep.SubInterpreter;
import net.algart.jep.additions.ConfiguredInterpreter;
import net.algart.jep.additions.JepCreationTools;

public enum JepType {
    NORMAL("normal", "normal"),
    GLOBAL("global", "JVM-global"),
    SUB_INTERPRETER("sub-interpreter", "sub-interpreter (isolated)");

    private final String typeName;
    private final String prettyName;
    private static final Map<String, JepType> ALL_MODES;

    private JepType(String typeName, String prettyName) {
        this.typeName = Objects.requireNonNull(typeName);
        this.prettyName = prettyName;
    }

    public static Collection<String> typeNames() {
        return Collections.unmodifiableCollection(ALL_MODES.keySet());
    }

    public String typeName() {
        return this.typeName;
    }

    public String prettyName() {
        return this.prettyName;
    }

    public boolean isSubInterpreter() {
        return this == SUB_INTERPRETER;
    }

    public boolean isJVMGlobal() {
        return this == GLOBAL;
    }

    public ConfiguredInterpreter newLowLevelInterpreter(Supplier<JepConfig> configurationSupplier) {
        Objects.requireNonNull(configurationSupplier, "Null configuration supplier");
        return this.newLowLevelInterpreter(configurationSupplier.get());
    }

    public ConfiguredInterpreter newLowLevelInterpreter(JepConfig configuration) {
        Objects.requireNonNull(configuration, "Null configuration");
        SubInterpreter interpreter = this == SUB_INTERPRETER ? JepCreationTools.newSubInterpreter(configuration, this) : JepCreationTools.newSharedInterpreter(configuration, this);
        return new ConfiguredInterpreter((Interpreter)interpreter, configuration);
    }

    public static Optional<JepType> fromTypeName(String typeName) {
        return Optional.ofNullable(ALL_MODES.get(typeName));
    }

    static {
        ALL_MODES = new LinkedHashMap<String, JepType>();
        for (JepType type : JepType.values()) {
            ALL_MODES.put(type.typeName, type);
        }
    }
}

