/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep.additions;

import java.util.Objects;
import jep.JepException;
import jep.python.PyCallable;
import jep.python.PyObject;
import net.algart.jep.additions.AtomicPyCallable;
import net.algart.jep.additions.JepSingleThreadInterpreter;

public class AtomicPyObject
implements AutoCloseable {
    final JepSingleThreadInterpreter i;
    private final PyObject pyObject;

    AtomicPyObject(JepSingleThreadInterpreter interpreter, PyObject pyObject) {
        this.i = Objects.requireNonNull(interpreter, "Null interpreter");
        this.pyObject = Objects.requireNonNull(pyObject, "Null pyObject");
    }

    public PyObject pyObject() {
        return this.pyObject;
    }

    public AtomicPyObject getAtomic(String name) throws JepException {
        return this.i.wrapObject(this.getAttributeAs(name, PyObject.class));
    }

    public AtomicPyCallable getAtomicCallable(String name) throws JepException {
        return this.i.wrapCallable(this.getAttributeAs(name, PyCallable.class));
    }

    public Object getAttribute(String name) throws JepException {
        return this.getAttributeAs(name, Object.class);
    }

    public Object getAttributeOrNull(String name) throws JepException {
        return this.i.executeInSingleThread(() -> {
            try {
                return this.pyObject.getAttr(name);
            }
            catch (JepException e) {
                return null;
            }
        });
    }

    public <T> T getAttributeAs(String name, Class<T> resultClass) throws JepException {
        Objects.requireNonNull(resultClass, "Null resultClass");
        return (T)this.i.executeInSingleThread(() -> this.pyObject.getAttr(name, resultClass));
    }

    public void setAttribute(String name, Object value) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.i.executeInSingleThread(() -> this.pyObject.setAttr(name, value));
    }

    public void removeAttribute(String name) throws JepException {
        Objects.requireNonNull(name, "Null name");
        this.i.executeInSingleThread(() -> this.pyObject.delAttr(name));
    }

    public AtomicPyObject invokeAsObject(String methodName, Object ... args) {
        return this.i.wrapObject(this.invokeAs(methodName, PyObject.class, args));
    }

    public Object invoke(String methodName, Object ... args) {
        return this.invokeAs(methodName, Object.class, args);
    }

    public <T> T invokeAs(String methodName, Class<T> resultClass, Object ... args) {
        Objects.requireNonNull(methodName, "Null methodName");
        Objects.requireNonNull(resultClass, "Null resultClass");
        try (AtomicPyCallable callable = this.getAtomicCallable(methodName);){
            T t = callable.callAs(resultClass, args);
            return t;
        }
    }

    public <T> T as(Class<T> expectedType) throws JepException {
        Objects.requireNonNull(expectedType, "Null expectedType");
        return (T)this.i.executeInSingleThread(() -> this.pyObject.as(expectedType));
    }

    @Override
    public void close() {
        this.i.executeInSingleThread(() -> ((PyObject)this.pyObject).close());
    }

    public String toString() {
        return "atomic wrapper for " + this.i.executeInSingleThread(() -> ((PyObject)this.pyObject).toString());
    }
}

