/*
 * Decompiled with CFR 0.152.
 */
package net.algart.jep;

import java.util.Objects;
import jep.JepConfig;
import jep.python.PyCallable;
import jep.python.PyObject;
import net.algart.jep.additions.AtomicPyCallable;
import net.algart.jep.additions.AtomicPyObject;
import net.algart.jep.additions.JepExtendedConfiguration;
import net.algart.jep.additions.JepSingleThreadInterpreter;
import net.algart.jep.additions.JepType;

public final class JepPerformer
implements AutoCloseable {
    static final System.Logger LOG = System.getLogger(JepPerformer.class.getName());
    final JepSingleThreadInterpreter context;
    private final JepType type;
    private final JepConfig configuration;

    private JepPerformer(JepSingleThreadInterpreter context) {
        this.context = Objects.requireNonNull(context, "Null JEP context");
        this.type = context.type();
        this.configuration = context.configuration();
    }

    public static JepPerformer newPerformer(JepSingleThreadInterpreter context) {
        return new JepPerformer(context);
    }

    public JepSingleThreadInterpreter context() {
        return this.context;
    }

    public JepType type() {
        return this.type;
    }

    public JepConfig configuration() {
        return this.configuration;
    }

    public Object verificationStatus() {
        Object object;
        JepConfig configuration = this.context.configuration();
        if (configuration instanceof JepExtendedConfiguration) {
            JepExtendedConfiguration extendedConfiguration = (JepExtendedConfiguration)configuration;
            object = extendedConfiguration.getVerificationStatus();
        } else {
            object = null;
        }
        return object;
    }

    public void perform(String code) {
        Objects.requireNonNull(code, "Null code");
        this.context.exec(code);
    }

    public void performFile(String path) {
        Objects.requireNonNull(path, "Null path");
        this.context.runScript(path);
    }

    public void putValue(String valueName, Object value) {
        Objects.requireNonNull(valueName, "Null valueName");
        this.context.set(valueName, value);
    }

    public Object getRawValue(String valueName) {
        Objects.requireNonNull(valueName, "Null valueName");
        return this.context.getValue(valueName);
    }

    public <T> T getValueAs(String valueName, Class<T> valueClass) {
        Objects.requireNonNull(valueName, "Null valueName");
        Objects.requireNonNull(valueClass, "Null valueClass");
        return this.context.getValue(valueName, valueClass);
    }

    public AtomicPyObject getObject(String valueName) {
        return this.context.wrapObject(this.getValueAs(valueName, PyObject.class));
    }

    public AtomicPyCallable getCallable(String valueName) {
        PyCallable callable = this.type.isSubInterpreter() ? (PyCallable)this.getRawValue(valueName) : this.getValueAs(valueName, PyCallable.class);
        return this.context.wrapCallable(callable);
    }

    public Object invokeFunction(String functionName, Object ... args) {
        Objects.requireNonNull(functionName, "Null functionName");
        return this.context.invoke(functionName, args);
    }

    public AtomicPyObject newObject(String className, Object ... args) {
        Objects.requireNonNull(className, "Null Python class name");
        try (AtomicPyCallable callable = this.getCallable(className);){
            AtomicPyObject atomicPyObject = this.type.isSubInterpreter() ? callable.callRawAtomic(args) : callable.callAsAtomic(args);
            return atomicPyObject;
        }
    }

    public AtomicPyObject wrapObject(PyObject pyObject) {
        return this.context.wrapObject(pyObject);
    }

    public AtomicPyCallable wrapCallable(PyCallable pyCallable) {
        return this.context.wrapCallable(pyCallable);
    }

    @Override
    public void close() {
        this.context.close();
    }

    public String toString() {
        return "Python performer of " + String.valueOf(this.context);
    }
}

