/*
 * Decompiled with CFR 0.152.
 */
package net.algart.graalvm;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Supplier;
import javax.lang.model.SourceVersion;
import net.algart.graalvm.GraalPerformer;
import org.graalvm.polyglot.Value;

public class JSInterpretation {
    private JSInterpretation() {
    }

    public static String importJSCode(String from, String ... importList) {
        Objects.requireNonNull(from, "Null from");
        Objects.requireNonNull(importList, "Null import list");
        if (importList.length == 0) {
            throw new IllegalArgumentException("Empty import list in not allowed");
        }
        StringBuilder sb = new StringBuilder();
        for (String name : importList) {
            if (!sb.isEmpty()) {
                sb.append(", ");
            }
            JSInterpretation.checkValidJSName(name, "import");
            sb.append(name);
        }
        return "import { " + String.valueOf(sb) + " } from \"" + from + "\";\n";
    }

    public static String importJSCode(Path moduleFile, String ... importList) {
        Objects.requireNonNull(moduleFile, "Null module file");
        if (!Files.exists(moduleFile, new LinkOption[0])) {
            throw new IllegalArgumentException("JS module file does not exist: " + String.valueOf(moduleFile));
        }
        if (!Files.isRegularFile(moduleFile, new LinkOption[0])) {
            throw new IllegalArgumentException("JS module file is not a regular file: " + String.valueOf(moduleFile));
        }
        String from = moduleFile.toAbsolutePath().normalize().toUri().toString();
        return JSInterpretation.importJSCode(from, importList);
    }

    public static String addJSExportFunction(String jsCode, String functionName, GraalPerformer performer) {
        Objects.requireNonNull(performer, "Null performer");
        return JSInterpretation.addJSExportFunction(jsCode, functionName, performer.isJsEsmEvalReturnsExports());
    }

    public static String addJSExportFunction(String jsCode, String functionName, boolean jsEsmEvalReturnsExports) {
        Objects.requireNonNull(jsCode, "Null jsCode");
        JSInterpretation.checkValidJSFunctionName(functionName);
        if (jsEsmEvalReturnsExports) {
            return jsCode + "\n\nexport {" + functionName + " }";
        }
        return jsCode + "\n\n" + functionName;
    }

    public static Value addedJSModuleMember(Value module, String functionName, GraalPerformer performer) {
        Objects.requireNonNull(performer, "Null performer");
        return JSInterpretation.addedJSModuleMember(module, functionName, performer.isJsEsmEvalReturnsExports());
    }

    public static Value addedJSModuleMember(Value module, String functionName, boolean jsEsmEvalReturnsExport) {
        Objects.requireNonNull(module, "Null module");
        return jsEsmEvalReturnsExport ? module.getMember(functionName) : module;
    }

    public static Value smartModuleMember(Value module, String name, Supplier<Value> defaultValue) {
        Objects.requireNonNull(module, "Null module");
        Objects.requireNonNull(name, "Null name");
        Objects.requireNonNull(defaultValue, "Null defaultValue");
        return module.hasMember(name) ? module.getMember(name) : defaultValue.get();
    }

    public static void checkValidJSFunctionName(String name) {
        JSInterpretation.checkValidJSName(name, "function");
    }

    private static void checkValidJSName(String name, String kind) {
        Objects.requireNonNull(name, "Null " + kind + " name");
        if (name.isBlank()) {
            throw new IllegalArgumentException("Empty JavaScript " + kind + " name \"" + name + "\" is not allowed");
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new IllegalArgumentException("Invalid JavaScript " + kind + " name \"" + name + "\": it contains illegal characters");
        }
    }
}

