/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.json;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.ScalarFilter;
import net.algart.json.Jsons;

public final class SetJsonValue
extends ScalarFilter {
    public static final String INPUT_JSON = "json";
    public static final String OUTPUT_JSON = "json";
    private String key = "jsonKey";
    private String value = "value";
    private JsonValueType jsonValueType = JsonValueType.STRING;

    public SetJsonValue() {
        this.setDefaultInputScalar("json");
        this.setDefaultOutputScalar("json");
    }

    public String getKey() {
        return this.key;
    }

    public SetJsonValue setKey(String key) {
        this.key = SetJsonValue.nonEmpty(key);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public SetJsonValue setValue(String value) {
        this.value = SetJsonValue.nonNull(value);
        return this;
    }

    public JsonValueType getJsonValueType() {
        return this.jsonValueType;
    }

    public SetJsonValue setJsonValueType(JsonValueType jsonValueType) {
        this.jsonValueType = SetJsonValue.nonNull(jsonValueType);
        return this;
    }

    @Override
    public SScalar process(SScalar source) {
        JsonObject json = Jsons.toJson(source.getValue(), true);
        JsonObjectBuilder builder = Jsons.createObjectBuilder(json);
        this.jsonValueType.add(builder, this.key, this.value.trim());
        return SScalar.of(Jsons.toPrettyString(builder.build()));
    }

    @Override
    protected boolean allowUninitializedInput() {
        return true;
    }

    public static enum JsonValueType {
        STRING{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, value);
            }
        }
        ,
        DOUBLE{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, Double.parseDouble(value));
            }
        }
        ,
        INTEGER{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, Long.parseLong(value));
            }
        }
        ,
        BOOLEAN{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, Boolean.parseBoolean(value));
            }
        }
        ,
        JSON_OBJECT{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, (JsonValue)Jsons.toJson(value));
            }
        }
        ,
        JSON_ARRAY{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, (JsonValue)Jsons.toJsonArray(value));
            }
        }
        ,
        NULL{

            @Override
            void add(JsonObjectBuilder builder, String key, String value) {
                builder.add(key, JsonValue.NULL);
            }
        };


        abstract void add(JsonObjectBuilder var1, String var2, String var3);
    }
}

