/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.io;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.io.FileOperation;
import net.algart.executors.modules.core.files.ListOfFiles;
import net.algart.executors.modules.core.scalars.io.ReadScalar;

public final class ReadNextScalar
extends FileOperation
implements ReadOnlyExecutionInput {
    public static final String OUTPUT_INDEX = "file_index";
    public static final String OUTPUT_NUMBER_OF_FILES = "number_of_files";
    public static final String OUTPUT_LIST_OF_FILES = "list_of_files";
    public static final String OUTPUT_LAST = "last";
    private String globPattern = "*.{txt}";
    private boolean recursiveScanning = true;
    private String charset = "UTF-8";
    private final List<Path> sortedFiles = new ArrayList<Path>();
    private String sortedFilesString = "";
    private int currentFileIndex = 0;

    public ReadNextScalar() {
        this.setFileExistenceRequired(false);
        this.addFileOperationPorts();
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
        this.addOutputScalar(OUTPUT_INDEX);
        this.addOutputScalar(OUTPUT_NUMBER_OF_FILES);
        this.addOutputScalar(OUTPUT_LIST_OF_FILES);
        this.addOutputScalar(OUTPUT_LAST);
    }

    public static ReadNextScalar getInstance() {
        return new ReadNextScalar();
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public ReadNextScalar setGlobPattern(String globPattern) {
        this.globPattern = ReadNextScalar.nonEmpty(globPattern);
        return this;
    }

    public boolean isRecursiveScanning() {
        return this.recursiveScanning;
    }

    public ReadNextScalar setRecursiveScanning(boolean recursiveScanning) {
        this.recursiveScanning = recursiveScanning;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public ReadNextScalar setCharset(String charset) {
        this.charset = ReadNextScalar.nonEmpty(charset).trim();
        return this;
    }

    public int currentFileIndex() {
        return this.currentFileIndex;
    }

    public int numberOfFiles() {
        return this.sortedFiles.size();
    }

    @Override
    public void initialize() {
        try {
            this.sortedFiles.clear();
            Path path = this.completeFilePath();
            ListOfFiles.findFiles(this.sortedFiles, path, this.globPattern, null, this.recursiveScanning);
            if (this.isFileExistenceRequired() && this.sortedFiles.isEmpty()) {
                throw new FileNotFoundException("No files in " + String.valueOf(path) + ", corresponding to pattern " + this.globPattern);
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        Collections.sort(this.sortedFiles);
        this.sortedFilesString = this.sortedFiles.stream().map(String::valueOf).collect(Collectors.joining("\n"));
        this.currentFileIndex = 0;
    }

    @Override
    public void process() {
        int numberOfFiles = this.sortedFiles.size();
        if (numberOfFiles == 0 && this.isFileExistenceRequired()) {
            throw new IllegalStateException("Illegal usage of process() method: initialize() was not successfully executed");
        }
        int fileIndex = this.currentFileIndex++;
        if (this.currentFileIndex >= numberOfFiles) {
            this.currentFileIndex = 0;
        }
        boolean last = this.currentFileIndex == 0;
        this.getScalar(OUTPUT_INDEX).setTo(fileIndex + 1);
        this.getScalar(OUTPUT_NUMBER_OF_FILES).setTo(numberOfFiles);
        this.getScalar(OUTPUT_LIST_OF_FILES).setTo(this.sortedFilesString);
        this.getScalar(OUTPUT_LAST).setTo(last);
        if (fileIndex >= numberOfFiles) {
            return;
        }
        Path fileToRead = this.sortedFiles.get(fileIndex).toAbsolutePath();
        Path absolutePath = fileToRead.toAbsolutePath();
        this.getScalar("absolute_path").setTo(absolutePath.toString());
        this.getScalar("parent_folder").setTo(absolutePath.getParent().toString());
        this.getScalar("file_name").setTo(absolutePath.getFileName().toString());
        ReadScalar readScalar = ReadScalar.getInstance();
        readScalar.setCharset(this.charset);
        readScalar.setFile(fileToRead.toString());
        String result = readScalar.readString();
        this.getScalar().setTo(result);
    }

    @Override
    protected boolean nonEmptyPathRequired() {
        return true;
    }
}

