/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.conversions;

import net.algart.executors.api.Executor;
import net.algart.executors.api.data.SScalar;

public final class SplitScalarToNumbers
extends Executor {
    private int blockLength = 1;
    private boolean singleBlock = true;

    public SplitScalarToNumbers() {
        this.addInputScalar(DEFAULT_INPUT_PORT);
        this.addOutputNumbers(DEFAULT_OUTPUT_PORT);
    }

    public int getBlockLength() {
        return this.blockLength;
    }

    public SplitScalarToNumbers setBlockLength(int blockLength) {
        this.blockLength = SplitScalarToNumbers.positive(blockLength);
        return this;
    }

    public boolean isSingleBlock() {
        return this.singleBlock;
    }

    public SplitScalarToNumbers setSingleBlock(boolean singleBlock) {
        this.singleBlock = singleBlock;
        return this;
    }

    @Override
    public void process() {
        SScalar scalar = this.getInputScalar();
        double[] array = scalar.toDoubles(0);
        this.getNumbers().setTo(array, this.singleBlock ? array.length : this.blockLength);
    }
}

