/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import java.util.List;
import net.algart.executors.api.data.SScalar;
import net.algart.executors.modules.core.common.scalars.SeveralScalarsOperation;
import net.algart.executors.modules.core.scalars.arithmetic.RoundScalar;

public final class LinearCombinationOfTwoScalars
extends SeveralScalarsOperation {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private double a = 1.0;
    private double b = 1.0;
    private double summand = 0.0;
    private boolean absoluteValue = false;
    private RoundScalar.RoundingMode roundingMode = RoundScalar.RoundingMode.NONE;

    public LinearCombinationOfTwoScalars() {
        super(INPUT_X, INPUT_Y);
    }

    public double getA() {
        return this.a;
    }

    public LinearCombinationOfTwoScalars setA(double a) {
        this.a = a;
        return this;
    }

    public double getB() {
        return this.b;
    }

    public LinearCombinationOfTwoScalars setB(double b) {
        this.b = b;
        return this;
    }

    public double getSummand() {
        return this.summand;
    }

    public LinearCombinationOfTwoScalars setSummand(double summand) {
        this.summand = summand;
        return this;
    }

    public boolean isAbsoluteValue() {
        return this.absoluteValue;
    }

    public LinearCombinationOfTwoScalars setAbsoluteValue(boolean absoluteValue) {
        this.absoluteValue = absoluteValue;
        return this;
    }

    public RoundScalar.RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public LinearCombinationOfTwoScalars setRoundingMode(RoundScalar.RoundingMode roundingMode) {
        this.roundingMode = LinearCombinationOfTwoScalars.nonNull(roundingMode);
        return this;
    }

    @Override
    public SScalar process(List<SScalar> sources) {
        double r;
        double x = sources.get(0).toDouble();
        Double y = sources.get(1).toDoubleOrNull();
        double d = r = y == null ? this.a * x + this.summand : this.a * x + this.b * y + this.summand;
        if (this.absoluteValue) {
            r = -r;
        }
        Number resultNumber = this.roundingMode.round(r);
        return SScalar.of(resultNumber);
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex > 0;
    }
}

