/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.scalars.arithmetic;

import java.util.Objects;
import net.algart.executors.api.Executor;
import net.algart.executors.modules.core.logic.ConditionStyle;

public final class CheckScalarsEquality
extends Executor {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private ComparisonMode comparisonMode = ComparisonMode.EQUAL;
    private ActionOnFail actionOnFail = ActionOnFail.RETURN_FALSE;
    private boolean numericComparison = false;
    private ConditionStyle booleanStyle = ConditionStyle.JAVA_LIKE;

    public CheckScalarsEquality() {
        this.addInputScalar(INPUT_X);
        this.addInputScalar(INPUT_Y);
        this.addOutputScalar(DEFAULT_OUTPUT_PORT);
    }

    public ComparisonMode getComparisonMode() {
        return this.comparisonMode;
    }

    public CheckScalarsEquality setComparisonMode(ComparisonMode comparisonMode) {
        this.comparisonMode = CheckScalarsEquality.nonNull(comparisonMode);
        return this;
    }

    public ActionOnFail getActionOnFail() {
        return this.actionOnFail;
    }

    public CheckScalarsEquality setActionOnFail(ActionOnFail actionOnFail) {
        this.actionOnFail = CheckScalarsEquality.nonNull(actionOnFail);
        return this;
    }

    public boolean isNumericComparison() {
        return this.numericComparison;
    }

    public CheckScalarsEquality setNumericComparison(boolean numericComparison) {
        this.numericComparison = numericComparison;
        return this;
    }

    public ConditionStyle getBooleanStyle() {
        return this.booleanStyle;
    }

    public CheckScalarsEquality setBooleanStyle(ConditionStyle booleanStyle) {
        this.booleanStyle = CheckScalarsEquality.nonNull(booleanStyle);
        return this;
    }

    @Override
    public void process() {
        boolean result;
        String y;
        String x;
        if (this.numericComparison) {
            x = this.getInputScalar(INPUT_X, false).getValue();
            y = this.getInputScalar(INPUT_Y, false).getValue();
            result = this.comparisonMode.compare(Double.parseDouble(x), Double.parseDouble(y));
        } else {
            x = this.getInputScalar(INPUT_X, true).getValue();
            y = this.getInputScalar(INPUT_Y, true).getValue();
            result = this.comparisonMode.compare(x, y);
        }
        this.booleanStyle.setScalar(this.getScalar(), result);
        if (!result && this.actionOnFail == ActionOnFail.THROW_EXCEPTION) {
            throw new AssertionError((Object)("Different scalars: " + x + " and " + y));
        }
    }

    public static enum ComparisonMode {
        EQUAL{

            @Override
            public boolean compare(String x, String y) {
                return Objects.equals(x, y);
            }

            @Override
            public boolean compare(double x, double y) {
                return x == y;
            }
        }
        ,
        UNEQUAL{

            @Override
            public boolean compare(String x, String y) {
                return !Objects.equals(x, y);
            }

            @Override
            public boolean compare(double x, double y) {
                return x != y;
            }
        };


        public abstract boolean compare(String var1, String var2);

        public abstract boolean compare(double var1, double var3);
    }

    public static enum ActionOnFail {
        RETURN_FALSE,
        THROW_EXCEPTION;

    }
}

