/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.function.DoubleUnaryOperator;
import net.algart.arrays.Arrays;
import net.algart.arrays.PArray;
import net.algart.arrays.UpdatablePNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.NumberArrayFilter;
import net.algart.executors.modules.core.numbers.arithmetic.NumbersExponent;
import net.algart.math.functions.Func;
import net.algart.math.functions.LogFunc;

public final class NumbersLogarithm
extends NumberArrayFilter
implements ReadOnlyExecutionInput {
    private LogarithmBase logarithmBase = LogarithmBase.BASE_10;
    private double customBase = 2.0;

    public LogarithmBase getLogarithmBase() {
        return this.logarithmBase;
    }

    public NumbersLogarithm setLogarithmBase(LogarithmBase logarithmBase) {
        this.logarithmBase = NumbersLogarithm.nonNull(logarithmBase);
        return this;
    }

    public double getCustomBase() {
        return this.customBase;
    }

    public NumbersLogarithm setCustomBase(double customBase) {
        this.customBase = customBase;
        return this;
    }

    @Override
    public PArray process(UpdatablePNumberArray array, int blockLength, int numberOfBlocks) {
        double base = this.logarithmBase.baseProducer.applyAsDouble(this.customBase);
        PArray array1 = Arrays.asFuncArray((Func)LogFunc.getInstance((double)base), NumbersExponent.resultClass((PArray)array), (PArray[])new PArray[]{array});
        return Arrays.clone((PArray)array1);
    }

    public static enum LogarithmBase {
        BASE_10(operand -> 10.0),
        BASE_E(operand -> Math.E),
        CUSTOM(operand -> operand);

        private final DoubleUnaryOperator baseProducer;

        private LogarithmBase(DoubleUnaryOperator baseProducer) {
            this.baseProducer = baseProducer;
        }
    }
}

