/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import java.util.List;
import net.algart.arrays.Arrays;
import net.algart.arrays.DoubleArray;
import net.algart.arrays.FloatArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.SeveralNumberArraysOperation;
import net.algart.math.functions.Func;
import net.algart.math.functions.LinearFunc;

public final class LinearCombinationOfTwoNumbers
extends SeveralNumberArraysOperation
implements ReadOnlyExecutionInput {
    public static final String INPUT_X = "x";
    public static final String INPUT_Y = "y";
    private double a = 1.0;
    private double b = 1.0;
    private double summand = 0.0;
    private boolean absoluteValue = false;

    public LinearCombinationOfTwoNumbers() {
        super(INPUT_X, INPUT_Y);
    }

    public double getA() {
        return this.a;
    }

    public LinearCombinationOfTwoNumbers setA(double a) {
        this.a = a;
        return this;
    }

    public double getB() {
        return this.b;
    }

    public LinearCombinationOfTwoNumbers setB(double b) {
        this.b = b;
        return this;
    }

    public double getSummand() {
        return this.summand;
    }

    public LinearCombinationOfTwoNumbers setSummand(double summand) {
        this.summand = summand;
        return this;
    }

    public boolean isAbsoluteValue() {
        return this.absoluteValue;
    }

    public void setAbsoluteValue(boolean absoluteValue) {
        this.absoluteValue = absoluteValue;
    }

    @Override
    public PArray process(List<PNumberArray> sources, int ... blockLengths) {
        PNumberArray x = sources.get(0);
        PNumberArray y = sources.get(1);
        Class resultType = x instanceof DoubleArray ? DoubleArray.class : FloatArray.class;
        PArray result = y == null ? Arrays.asFuncArray((Func)LinearFunc.getInstance((double)this.summand, (double[])new double[]{this.a}), resultType, (PArray[])new PArray[]{x}) : Arrays.asFuncArray((Func)LinearFunc.getInstance((double)this.summand, (double[])new double[]{this.a, this.b}), resultType, (PArray[])new PArray[]{x, y});
        if (this.absoluteValue) {
            result = Arrays.asFuncArray((Func)Func.ABS, resultType, (PArray[])new PArray[]{result});
        }
        return result;
    }

    @Override
    protected boolean allowUninitializedInput(int inputIndex) {
        return inputIndex > 0;
    }
}

