/*
 * Decompiled with CFR 0.152.
 */
package net.algart.executors.modules.core.numbers.arithmetic;

import net.algart.arrays.Array;
import net.algart.arrays.Arrays;
import net.algart.arrays.BitArray;
import net.algart.arrays.PArray;
import net.algart.arrays.PNumberArray;
import net.algart.executors.api.ReadOnlyExecutionInput;
import net.algart.executors.modules.core.common.numbers.NumberArrayToScalar;
import net.algart.executors.modules.core.numbers.arithmetic.CheckNumbersEquality;
import net.algart.math.functions.Func;
import net.algart.math.functions.RectangularFunc;

public final class CheckNumbersInRange
extends NumberArrayToScalar
implements ReadOnlyExecutionInput {
    private double min = 0.0;
    private double max = Double.POSITIVE_INFINITY;
    private boolean invert = false;
    private CheckNumbersEquality.ActionOnFail actionOnFail = CheckNumbersEquality.ActionOnFail.THROW_EXCEPTION;

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void setMin(String min) {
        this.min = CheckNumbersInRange.doubleOrNegativeInfinity(min);
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public void setMax(String max) {
        this.max = CheckNumbersInRange.doubleOrPositiveInfinity(max);
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean invert) {
        this.invert = invert;
    }

    public CheckNumbersEquality.ActionOnFail getActionOnFail() {
        return this.actionOnFail;
    }

    public void setActionOnFail(CheckNumbersEquality.ActionOnFail actionOnFail) {
        this.actionOnFail = CheckNumbersInRange.nonNull(actionOnFail);
    }

    @Override
    public Object analyseArray(PNumberArray array, int blockLength, int numberOfBlocks) {
        double outValue;
        double inValue = this.invert ? 1.0 : 0.0;
        BitArray elementsAreOutOfRange = (BitArray)Arrays.asFuncArray((Func)RectangularFunc.getInstance((double)this.min, (double)this.max, (double)inValue, (double)(outValue = this.invert ? 0.0 : 1.0)), BitArray.class, (PArray[])new PArray[]{array});
        boolean allInRange = elementsAreOutOfRange.isZeroFilled();
        if (allInRange) {
            return true;
        }
        switch (this.actionOnFail) {
            case RETURN_FALSE: {
                break;
            }
            case THROW_EXCEPTION: {
                this.getScalar().setTo(false);
                throw new AssertionError((Object)("Input array contains numbers " + (this.invert ? "inside" : "outside") + " the range " + this.min + ".." + this.max + ": " + Arrays.toString((Array)array, (String)", ", (int)1000)));
            }
            default: {
                throw new UnsupportedOperationException("Invalid " + String.valueOf((Object)this.actionOnFail));
            }
        }
        return false;
    }
}

